<?php
function checkSession($conn){

    // Ja nav session_token → lietotājs nav ielogojies
    if (!isset($_SESSION['session_token'])) {
        return false;
    }

    $token = $_SESSION['session_token']; // Saglabā tokenu mainīgajā

    // Izsauc DB procedūru, kas atdod username, last_activity un is_active
    $stmt = $conn->prepare("CALL check_session(?)");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $res = $stmt->get_result();

    // Ja DB neatgriež ierakstu (token neeksistē vai sesija izdzēsta)
    if (!$res || !$row = $res->fetch_assoc()) {
        $stmt->close();
        $conn->next_result(); // atbrīvo rezultātu pēc CALL
        session_destroy();   // iznīcina PHP sesiju
        return false;        // sesija nav derīga
    }

    $stmt->close();
    $conn->next_result();

    // Ja DB jau rāda, ka sesija nav aktīva
    if ((int)$row['is_active'] === 0) {
        session_destroy();
        $_SESSION['session_expired'] = "Sesija beigusies.";
        return "expired";
    }

    // Timeout pārbaude (60 sek)
    $lastActivity = strtotime($row['last_activity']);
    if (time() - $lastActivity > 60) {

        // Atzīmē sesiju DB kā neaktīvu
        $stmt2 = $conn->prepare("UPDATE sessions SET is_active = 0 WHERE session_token = ?");
        $stmt2->bind_param("s", $token);
        $stmt2->execute();
        $stmt2->close();

        session_destroy(); // iznīcina PHP sesiju
        $_SESSION['session_expired'] = "Sesija beigusies.";
        return "expired";
    }

    // Šeit sesija ir derīga
    // last_activity netiek atjaunots šeit, bet tikai action.php

    return $row['username']; // atgriež lietotājvārdu
}
?>
