<?php
session_start();              // Sāk PHP sesiju (lai var saglabāt paziņojumus)
include "connection.php";     // Pieslēgums datubāzei

$message = "";                // Mainīgais kļūdu paziņojumiem

// Ja forma iesniegta
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    // Paroli pārvērš drošā hash formātā
    $hash = password_hash($_POST['password'], PASSWORD_DEFAULT);

    try {
        // Izsauc procedūru, kas izveido jaunu lietotāju DB
        $stmt = $conn->prepare("CALL create_user(?, ?)");
        $stmt->bind_param("ss", $_POST['username'], $hash);
        $stmt->execute();
        $stmt->close();
        $conn->next_result(); // obligāti pēc CALL

        // Saglabā veiksmīgas reģistrācijas ziņu sesijā
        $_SESSION['success_register'] = "Reģistrācija veiksmīga!";

        // Pārsūta uz sākuma lapu
        header("Location: index.php");
        exit();

    } catch (Exception $e) {
        // Ja lietotājs jau eksistē (unique kļūda)
        $message = "Lietotājs jau eksistē!";
    }
}
?>
<html>
<head>
<link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
<h2>Reģistrācija</h2>

<!-- Ja ir kļūda, parāda to -->
<?php if($message) echo '<div class="message error">'.$message.'</div>'; ?>

<!-- Reģistrācijas forma -->
<form method="post">
<input type="text" name="username" placeholder="Lietotājvārds" required>
<input type="password" name="password" placeholder="Parole" required>
<button class="green">Reģistrēties</button>
</form>

<!-- Saite uz login -->
<a href="login.php">Jau ir konts?</a>
</div>
</body>
</html>
