<?php
session_start();              // Sāk PHP sesiju
include "connection.php";     // Pieslēgums datubāzei

$message = "";                // Mainīgais paziņojumiem lietotājam

/*  JA SESIJA BEIGUSIES (atnāci no JS redirect ar ?message=expired) */
if (isset($_GET['message']) && $_GET['message'] === "expired") {

    $message = "Sesija beigusies.";  // Ziņa, ko parādīt login lapā

    // Ja bija aktīvs session_token, tad DB sesiju atzīmē kā neaktīvu
    if (isset($_SESSION['session_token'])) {
        $stmt = $conn->prepare("UPDATE sessions SET is_active = 0 WHERE session_token = ?");
        $stmt->bind_param("s", $_SESSION['session_token']); // piesaista tokenu
        $stmt->execute();  // izpilda update
        $stmt->close();    // aizver vaicājumu
    }

    // ❗ Neiznīcina visu PHP sesiju!
    unset($_SESSION['session_token']); // izdzēš tikai tokenu
    session_regenerate_id(true);       // drošībai izveido jaunu sesijas ID
}

/* 🔐 LOGIN APSTRĀDE, kad lietotājs nospiež "Pieslēgties" */
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    // Izsauc DB procedūru, kas atrod lietotāju pēc username
    $stmt = $conn->prepare("CALL check_login(?)");
    $stmt->bind_param("s", $_POST['username']);
    $stmt->execute();
    $res = $stmt->get_result();

    // Ja lietotājs DB atrasts
    if ($row = $res->fetch_assoc()) {
        $stmt->close();
        $conn->next_result(); // obligāti pēc CALL

        // Pārbauda paroli ar hash
        if (password_verify($_POST['password'], $row['password_hash'])) {

            // Izveido drošu session token
            $token = bin2hex(random_bytes(32));

            // Izsauc procedūru, kas izveido sesiju DB
            $stmt2 = $conn->prepare("CALL create_session(?, ?)");
            $stmt2->bind_param("is", $row['id'], $token);
            $stmt2->execute();
            $stmt2->close();
            $conn->next_result();

            // Saglabā token PHP sesijā
            $_SESSION['session_token'] = $token;

            // Veiksmīgas pieslēgšanās paziņojums
            $_SESSION['success_login'] = "Pieslēgšanās veiksmīga!";

            // Pārsūta uz galveno lapu
            header("Location: index.php");
            exit();
        }
    } else {
        // Ja lietotājs nav atrasts
        $stmt->close();
        $conn->next_result();
    }

    // Ja parole nepareiza vai lietotājs nav atrasts
    $message = "Nepareizi dati!";
}
?>
<html>
<head>
<link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
<h2>Pieslēgšanās</h2>

<!-- Parāda kļūdas vai timeout ziņu -->
<?php if ($message): ?>
<div class="message error"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>

<!-- Login forma -->
<form method="post">
<input type="text" name="username" placeholder="Lietotājvārds" required>
<input type="password" name="password" placeholder="Parole" required>
<button class="green">Pieslēgties</button>
</form>

<a href="register.php">Nav konta?</a>
</div>
</body>
</html>
