<?php
session_start();              // Sāk PHP sesiju
include "connection.php";     // Pieslēgums datubāzei
include "session.php";        // Sesijas pārbaudes funkcija

$username = "Viesis";         // Noklusējuma vārds, ja nav ielogojies
$loggedIn = false;            // Karogs, vai lietotājs ir ielogojies

$result = checkSession($conn); // Pārbauda sesijas derīgumu

// Ja sesija beigusies tad suta uz login ar ziņu
if ($result === "expired") {
    header("Location: login.php?message=expired");
    exit();
}
// Ja sesija derīga → iegūst lietotājvārdu
elseif ($result !== false) {
    $username = $result;
    $loggedIn = true;
}
?>
<html>
<head>
    <link rel="stylesheet" href="style.css"> <!-- CSS dizaina links -->
</head>
<body>
<div class="container">

<!-- Parāda lietotāja vārdu vai "Viesis" -->
<h2>Sveiks, <?=htmlspecialchars($username)?></h2>

<!-- Veiksmīgas reģistrācijas ziņa -->
<?php
if(isset($_SESSION['success_register'])){
    echo '<div class="message success">'.$_SESSION['success_register'].'</div>';
    unset($_SESSION['success_register']); // lai nerādās atkārtoti
}
?>

<!-- Veiksmīgas pieslēgšanās vai darbības ziņa -->
<?php
if(isset($_SESSION['success_login'])){
    echo '<div class="message success">'.$_SESSION['success_login'].'</div>';
    unset($_SESSION['success_login']);
}
?>

<!-- Ja lietotājs NAV ielogojies -->
<?php if(!$loggedIn): ?>
    <a href="login.php"><button class="green">Pieslēgties</button></a>
    <a href="register.php"><button class="green">Reģistrēties</button></a>

<!-- Ja lietotājs IR ielogojies -->
<?php else: ?>
    <!-- Poga, kas pagarina sesiju -->
    <form action="action.php" method="post">
        <button class="blue">Darbība</button>
    </form>

    <!-- Dzēš lietotāja profilu -->
    <a href="delete_user.php"><button class="orange">Dzēst lietotāju</button></a>

    <!-- Izrakstīšanās -->
    <a href="logout.php"><button class="red">Iziet</button></a>
<?php endif; ?>

</div>

<!-- Automātisks timeout tikai, ja ielogojies -->
<?php if($loggedIn): ?>
<script>
    // Pēc 60 sekundēm pārsūta uz login lapu
    // Tas izraisa sesijas izslēgšanu serverī
    setTimeout(function() {
        window.location.href = "login.php?message=expired";
    }, 60000);
</script>
<?php endif; ?>

</body>
</html>
