<?php
session_start(); // Sāk PHP sesiju
include "connection.php"; // Pieslēgums datubāzei
include "session.php";    // Funkcija checkSession()

// Pārbauda, vai sesija vēl derīga
$result = checkSession($conn);

// Ja sesija beigusies vai nav derīga tad suta atpakaļ uz login
if ($result === "expired" || $result === false) {
    header("Location: login.php?message=expired");
    exit();
}

// Iegūst lietotāja ID no sessions tabulas, izmantojot session_token
$stmt = $conn->prepare("SELECT user_id FROM sessions WHERE session_token=?");
$stmt->bind_param("s", $_SESSION['session_token']); // piesaista tokenu
$stmt->execute();
$stmt->bind_result($uid); // rezultāts tiks saglabāts $uid
$stmt->fetch();
$stmt->close(); // aizver vaicājumu

// Izsauc procedūru, kas dzēš lietotāju no users tabulas
$stmt2 = $conn->prepare("CALL delete_user(?)");
$stmt2->bind_param("i", $uid); // padod lietotāja ID
$stmt2->execute();
$stmt2->close();
$conn->next_result(); // nepieciešams pēc CALL procedūras

// Iznīcina PHP sesiju pēc lietotāja dzēšanas
session_destroy();

// Pārsūta uz sākuma lapu
header("Location: index.php");
?>
