<?php
require __DIR__ . "/../config/db.php";

$msg = $err = "";

if (isset($_GET["toggle"])) {
  $id = (int)$_GET["toggle"];
  $pdo->prepare("UPDATE tasks SET status = IF(status='NEW','DONE','NEW') WHERE id=?")->execute([$id]);
  $msg = "Statuss nomainīts.";
}

if (isset($_GET["del"])) {
  $id = (int)$_GET["del"];
  $pdo->prepare("DELETE FROM tasks WHERE id=?")->execute([$id]);
  $msg = "Uzdevums dzēsts.";
}

$rows = $pdo->query("
  SELECT t.*, c.name AS category_name
  FROM tasks t
  LEFT JOIN categories c ON c.id = t.category_id
  ORDER BY t.created_at DESC
")->fetchAll();
?>
<!doctype html>
<html lang="lv">
<head>
  <meta charset="utf-8">
  <title>WEB darbs - Uzdevumi</title>
  <link rel="stylesheet" href="style.css">
</head>
<body>
  <div class="container">
    <h2>WEB moduļa darbs: 3. logs – Uzdevumu saraksts (parāda + labo datus)</h2>
    <?php include "nav.php"; ?>

    <?php if($msg): ?><div class="msg"><?=htmlspecialchars($msg)?></div><?php endif; ?>
    <?php if($err): ?><div class="err"><?=htmlspecialchars($err)?></div><?php endif; ?>

    <div class="card">
      <table>
        <tr>
          <th>ID</th><th>Nosaukums</th><th>Kategorija</th><th>Prioritāte</th><th>Termiņš</th><th>Statuss</th><th>Darbības</th>
        </tr>
        <?php foreach($rows as $t): ?>
          <tr>
            <td><?=$t['id']?></td>
            <td><?=htmlspecialchars($t['title'])?></td>
            <td><?=htmlspecialchars($t['category_name'] ?? 'Bez kategorijas')?></td>
            <td><?=$t['priority']?></td>
            <td><?php
              $d = $t['due_date'] ?? '';
              echo ($d === '' || $d === '0000-00-00') ? '-' : htmlspecialchars($d);
            ?></td>
            <td><?=$t['status']?></td>
            <td>
              <a href="?toggle=<?=$t['id']?>">Mainīt statusu</a> |
              <a href="?del=<?=$t['id']?>" onclick="return confirm('Dzēst?')">Dzēst</a>
            </td>
          </tr>
        <?php endforeach; ?>
      </table>
    </div>
  </div>
</body>
</html>
