<?php
require __DIR__ . "/../config/db.php";

$msg = $err = "";

if (isset($_POST["add"])) {
  $name = trim($_POST["name"] ?? "");
  if ($name === "") $err = "Kategorijas nosaukums ir obligāts.";
  else {
    try {
      $pdo->prepare("INSERT INTO categories(name) VALUES (?)")->execute([$name]);
      $msg = "Kategorija pievienota!";
    } catch(Exception $e){
      $err = "Neizdevās pievienot (iespējams, jau eksistē).";
    }
  }
}

if (isset($_GET["del"])) {
  $id = (int)$_GET["del"];
  $pdo->prepare("DELETE FROM categories WHERE id=?")->execute([$id]);
  $msg = "Kategorija dzēsta.";
}

$cats = $pdo->query("SELECT id,name FROM categories ORDER BY name")->fetchAll();
?>
<!doctype html>
<html lang="lv">
<head>
  <meta charset="utf-8">
  <title>WEB darbs - Kategorijas</title>
  <link rel="stylesheet" href="style.css">
</head>
<body>
  <div class="container">
    <h2>WEB moduļa darbs: 2. logs – Kategoriju pārvaldība</h2>
    <?php include "nav.php"; ?>

    <?php if($msg): ?><div class="msg"><?=htmlspecialchars($msg)?></div><?php endif; ?>
    <?php if($err): ?><div class="err"><?=htmlspecialchars($err)?></div><?php endif; ?>

    <div class="card">
      <form method="post">
        <label>Jauna kategorija</label>
        <input name="name" placeholder="piem., Skola" required>
        <button name="add" type="submit">Pievienot</button>
      </form>
    </div>

    <div class="card">
      <h3>Esošās kategorijas</h3>
      <table>
        <tr><th>ID</th><th>Nosaukums</th><th>Darbība</th></tr>
        <?php foreach($cats as $c): ?>
          <tr>
            <td><?=$c['id']?></td>
            <td><?=htmlspecialchars($c['name'])?></td>
            <td><a href="?del=<?=$c['id']?>" onclick="return confirm('Dzēst?')">Dzēst</a></td>
          </tr>
        <?php endforeach; ?>
      </table>
    </div>
  </div>
</body>
</html>
