<?php
require __DIR__ . "/../config/db.php";

$msg = $err = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $title = trim($_POST["title"] ?? "");
  $description = trim($_POST["description"] ?? "");
  $priority = (int)($_POST["priority"] ?? 3);
  $due_date = $_POST["due_date"] ?? null;
  $category_id = (int)($_POST["category_id"] ?? 0);

  if ($title === "") {
    $err = "Nosaukums ir obligāts.";
  } else {
    $stmt = $pdo->prepare("INSERT INTO tasks(title,description,priority,due_date,category_id) VALUES (?,?,?,?,?)");
    $stmt->execute([$title, $description, $priority, ($due_date?:null), ($category_id?:null)]);
    $msg = "Uzdevums saglabāts!";
  }
}

$cats = $pdo->query("SELECT id,name FROM categories ORDER BY name")->fetchAll();
?>
<!doctype html>
<html lang="lv">
<head>
  <meta charset="utf-8">
  <title>WEB darbs - Uzdevuma pievienošana</title>
  <link rel="stylesheet" href="style.css">
</head>
<body>
  <div class="container">
    <h2>WEB moduļa darbs: 1. logs – Uzdevuma pievienošana</h2>
    <?php include "nav.php"; ?>

    <?php if($msg): ?><div class="msg"><?=htmlspecialchars($msg)?></div><?php endif; ?>
    <?php if($err): ?><div class="err"><?=htmlspecialchars($err)?></div><?php endif; ?>

    <div class="card">
      <form method="post">
        <label>Nosaukums</label>
        <input name="title" required>

        <label>Apraksts</label>
        <textarea name="description" rows="4"></textarea>

        <label>Prioritāte (1-5)</label>
        <input type="number" name="priority" min="1" max="5" value="3">

        <label>Termiņš (nav obligāts)</label>
        <input type="date" name="due_date">

        <label>Kategorija</label>
        <select name="category_id">
          <option value="">-- Bez kategorijas --</option>
          <?php foreach($cats as $c): ?>
            <option value="<?=$c['id']?>"><?=htmlspecialchars($c['name'])?></option>
          <?php endforeach; ?>
        </select>

        <button type="submit">Saglabāt</button>
      </form>
    </div>
  </div>
</body>
</html>
