<?php
require __DIR__ . "/helpers.php";

$username = current_username();
$isLogged = 0;

if ($username !== "") {
  $isLogged = call_fn("fn_is_logged_in", [$username]);
  if ($isLogged === 0) {
    unset($_SESSION["username"]);
    $username = "";
  }
}

$msg = $err = "";

if (isset($_POST["action"])) {
  if ($username === "") {
    $err = "Nav atļauts veikt darbību. Lūdzu pieslēdzies.";
  } else {
    $ok = call_fn("fn_do_action", [$username]);
    if ($ok === 1) $msg = "Darbība izpildīta. Sesijas laiks atjaunots.";
    else $err = "Darbība nav atļauta (iespējams, beidzies noilgums).";
  }
}

if (isset($_POST["logout"])) {
  if ($username !== "") {
    call_fn("fn_logout", [$username]);
  }
  unset($_SESSION["username"]);
  $username = "";
  $msg = "Izlogošanās veiksmīgi pabeigta.";
}
?>
<!doctype html>
<html lang="lv">
<head>
  <meta charset="utf-8">
  <title>DB projekts - Galvenais logs</title>
  <link rel="stylesheet" href="style.css">
</head>
<body>
  <div class="topbar">
    <div><strong>DB projekts</strong> <small>(2 logi: login/register + galvenais)</small></div>
    <div class="badge">Lietotājs: <strong><?=htmlspecialchars($username !== "" ? $username : "Viesis")?></strong></div>
  </div>

  <div class="container">
    <?php if($msg): ?><div class="msg"><?=htmlspecialchars($msg)?></div><?php endif; ?>
    <?php if($err): ?><div class="err"><?=htmlspecialchars($err)?></div><?php endif; ?>

    <div class="card">
      <h2>Galvenais logs</h2>
      <p>Statuss: <?= $username !== "" ? "Pieslēdzies" : "Nav pieslēdzies" ?></p>

      <?php if($username === ""): ?>
        <a href="auth.php?mode=login"><button type="button">Pieslēgties</button></a>
        <a href="auth.php?mode=register"><button type="button">Reģistrēties</button></a>
      <?php else: ?>
        <form method="post" style="display:flex; gap:10px; flex-wrap:wrap;">
          <button name="logout" value="1">Iziet</button>
          <button name="action" value="1">Darbība</button>
        </form>
        <small>“Darbība” simulē aktivitāti un pagarina sesiju. Ja ilgstoši neko nedara, notiek automātiska izlogošana (noilgums).</small>
      <?php endif; ?>
    </div>
  </div>
</body>
</html>
