<?php
require __DIR__ . "/../config/db.php";
session_start();

function call_fn(string $fn, array $params): int {
  global $pdo;
  $placeholders = implode(",", array_fill(0, count($params), "?"));
  $stmt = $pdo->prepare("SELECT {$fn}({$placeholders}) AS res");
  $stmt->execute($params);
  $row = $stmt->fetch();
  return (int)($row["res"] ?? 0);
}

function current_username(): string {
  return $_SESSION["username"] ?? "";
}
?>