<?php
require __DIR__ . "/helpers.php";

$mode = $_GET["mode"] ?? "login"; // login | register
$msg = $err = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $username = trim($_POST["username"] ?? "");
  $password = $_POST["password"] ?? "";

  if ($mode === "register") {
    $ok = call_fn("fn_create_user", [$username, $password]);
    if ($ok === 1) $msg = "Reģistrācija veiksmīga! Tagad vari pieslēgties.";
    else $err = "Reģistrācija neizdevās (lietotājs varbūt jau eksistē).";
  } else {
    $ok = call_fn("fn_check_login", [$username, $password]);
    if ($ok === 1) {
      $_SESSION["username"] = $username;
      header("Location: home.php");
      exit;
    } else {
      $err = "Nepareizs lietotājvārds vai parole.";
    }
  }
}
?>
<!doctype html>
<html lang="lv">
<head>
  <meta charset="utf-8">
  <title>DB projekts - <?=htmlspecialchars($mode)?></title>
  <link rel="stylesheet" href="style.css">
</head>
<body>
  <div class="topbar">
    <div><strong>DB projekts</strong> <small>Login tikai ar MySQL funkcijām</small></div>
    <div class="badge"><a href="home.php">Uz galveno</a></div>
  </div>

  <div class="container">
    <div class="card">
      <h2><?= $mode === "register" ? "Reģistrēties" : "Pieslēgties" ?></h2>

      <?php if($msg): ?><div class="msg"><?=htmlspecialchars($msg)?></div><?php endif; ?>
      <?php if($err): ?><div class="err"><?=htmlspecialchars($err)?></div><?php endif; ?>

      <form method="post">
        <label>Lietotājvārds</label>
        <input name="username" required>

        <label>Parole</label>
        <input name="password" type="password" required>

        <button type="submit"><?= $mode === "register" ? "Reģistrēties" : "Pieslēgties" ?></button>
      </form>

      <p>
        <?php if($mode === "register"): ?>
          <a href="auth.php?mode=login">Ir konts? Pieslēgties</a>
        <?php else: ?>
          <a href="auth.php?mode=register">Nav konta? Reģistrēties</a>
        <?php endif; ?>
      </p>
      <small>Piezīme: PHP kods neizmanto tabulas tieši – izsauc tikai MySQL funkcijas (SELECT fn_...).</small>
    </div>
  </div>
</body>
</html>
