<?php
session_start();

// db konekcija
$host = 'localhost';
$db = 'db_funkc';
$user = 'root';
$pass = '';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (Exception $e) {
    exit("DB Connection failed: " . $e->getMessage());
}

// get action
$action = $_POST['action'] ?? '';

function generateToken($length = 32){
    return bin2hex(random_bytes($length));
}

// registresana
if($action === 'register'){
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    if(!$username || !$password){
        echo "Ievadiet lietotājvārdu un paroli!";
        exit;
    }

    $password_hash = password_hash($password, PASSWORD_DEFAULT); // hasho paroli

    $stmt = $pdo->query("SELECT create_user_fn('$username', '$password_hash') AS success");
    $result = $stmt->fetch();

    if($result['success']){
        echo "OK";
    } else {
        echo "Lietotājvārds jau eksistē!"; // ja lietotajvards eksiste tas izvada pazinojumu
    }
    exit;
}

// pieslegsanas
if($action === 'login'){
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    if(!$username || !$password){
        echo "Ievadiet lietotājvārdu un paroli!";
        exit;
    }

    // iegust hashotu paroli no datubazes
    $stmt = $pdo->prepare("SELECT password_hash, user_id FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch();

    if($user && password_verify($password, $user['password_hash'])){
        // izveido sesiju
        $token = generateToken();
        $stmt = $pdo->prepare("INSERT INTO sessions (user_id, token, created_at, expires_at) VALUES (?, ?, NOW(), DATE_ADD(NOW(), INTERVAL 30 MINUTE))");
        $stmt->execute([$user['user_id'], $token]);

        $_SESSION['token'] = $token;
        echo "OK";
    } else {
        echo "Nepareizi dati"; // ja nepareizi tiek ievadits vai nu lietotajvards vai parole, izvada pazinojumu
    }
    exit;
}

// iziesana
if($action === 'logout'){
    if(isset($_SESSION['token'])){
        $token = $_SESSION['token'];
        $stmt = $pdo->prepare("DELETE FROM sessions WHERE token = ?"); // ja lietotajs iziet, no db sesssions tabulas tiek izdests liet.
        $stmt->execute([$token]);
        unset($_SESSION['token']);
    }
    echo "OK";
    exit;
}

// sesijas atsvaidzinasana
if($action === 'action'){
    if(!isset($_SESSION['token'])){
        echo "NOT_LOGGED_IN";
        exit;
    }

    $token = $_SESSION['token'];

    // parbauda vai sesija eksiste un vai nav beigusies
    $stmt = $pdo->prepare("SELECT user_id FROM sessions WHERE token = ? AND expires_at > NOW()");
    $stmt->execute([$token]);
    $session = $stmt->fetch();

    if($session){
        // atsvaidzina sesiju
        $stmt = $pdo->prepare("UPDATE sessions SET expires_at = DATE_ADD(NOW(), INTERVAL 30 MINUTE) WHERE token = ?");
        $stmt->execute([$token]);
        echo "UPDATED";
    } else {
        unset($_SESSION['token']);
        echo "TIMEOUT";
    }
    exit;
}

// parbauda sesiju
if($action === 'check'){
    if(!isset($_SESSION['token'])){
        echo "TIMEOUT";
        exit;
    }

    $token = $_SESSION['token'];
    $stmt = $pdo->prepare("SELECT user_id FROM sessions WHERE token = ? AND expires_at > NOW()");
    $stmt->execute([$token]);
    $session = $stmt->fetch();

    if($session){
        echo "ACTIVE";
    } else {
        unset($_SESSION['token']);
        echo "TIMEOUT";
    }
    exit;
}

?>
