const welcome = document.getElementById("welcome");

// rikojas ar pieslegsanas un registracijas logiem, lai nebutu nepareiza vieta
function openLogin() { document.getElementById("login").style.display = "flex"; }
function closeModals() { 
    document.getElementById("login").style.display = "none"; 
    document.getElementById("register").style.display = "none"; 
}
function switchToRegister() { 
    closeModals(); 
    document.getElementById("register").style.display = "flex"; 
}
function switchToLogin() { 
    closeModals(); 
    document.getElementById("login").style.display = "flex"; 
}

// registracija
function handleRegister() {
    const username = document.getElementById("registerUsername").value;
    const password = document.getElementById("registerPassword").value;

    if(!username || !password) return alert("Ievadiet lietotājvārdu un paroli!");
// hasho paroli
    fetch("../php/index_php.php", {
        method: "POST",
        headers: {"Content-Type":"application/x-www-form-urlencoded"},
        body: `action=register&username=${encodeURIComponent(username)}&password=${encodeURIComponent(password)}`
    })
    .then(r => r.text())
    .then(res => {
        if(res.trim() === "OK"){
            alert("Konts izveidots!");
            switchToLogin();
        } else {
            alert(res);
        }
    });
}

// pieslegsanas
function handleLogin() {
    const username = document.getElementById("loginUsername").value;
    const password = document.getElementById("loginPassword").value;

    if(!username || !password) return alert("Ievadiet lietotājvārdu un paroli!");
// hasho paroli
    fetch("../php/index_php.php", {
        method: "POST",
        headers: {"Content-Type":"application/x-www-form-urlencoded"},
        body: `action=login&username=${encodeURIComponent(username)}&password=${encodeURIComponent(password)}`
    })
    .then(r => r.text())
    .then(res => {
        if(res.trim() === "OK"){
            welcome.textContent = `Sveiki ${username}!`;
            closeModals();
        } else {
            alert("Nepareizi dati");
        }
    });
}

// iziesana
function logout() {
    fetch("../php/index_php.php", {
        method: "POST",
        headers: {"Content-Type":"application/x-www-form-urlencoded"},
        body: "action=logout"
    })
    .then(() => {
        welcome.textContent = "Sveiki viesi!";
    });
}

// sesijas parbaudisana/darbiba
function action() {
    fetch("../php/index_php.php", {
        method: "POST",
        headers: {"Content-Type":"application/x-www-form-urlencoded"},
        body: "action=action"
    })
    .then(r => r.text())
    .then(res => {
        if(res.trim() === "UPDATED") alert("Sesija atjaunota"); // nospiezot darbibas pogu, sesija tiek atjaunota
        else alert("Jāpieslēdzas!");
    });
}

// automatiski parbauda vai darbojas ar programmu katras 10 sekundes, ja ne, tad izlogojas automatiski
setInterval(() => {
    fetch("../php/index_php.php", {
        method: "POST",
        headers: {"Content-Type":"application/x-www-form-urlencoded"},
        body: "action=check"
    })
    .then(r => r.text())
    .then(res => {
        if(res.trim() === "TIMEOUT"){
            welcome.textContent = "Sveiki viesi!";
        }
    });
}, 1000);
