-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               10.4.32-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win64
-- HeidiSQL Version:             12.6.0.6765
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- Dumping database structure for db_funkc
CREATE DATABASE IF NOT EXISTS `db_funkc` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci */;
USE `db_funkc`;

-- Dumping structure for function db_funkc.check_user_fn
DELIMITER //
CREATE FUNCTION `check_user_fn`(p_username VARCHAR(50), p_password_hash VARCHAR(255)) RETURNS tinyint(1)
    DETERMINISTIC
BEGIN
    DECLARE stored_hash VARCHAR(255);
    SELECT password_hash INTO stored_hash FROM users WHERE username = p_username;

    IF stored_hash = p_password_hash THEN
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END IF;
END//
DELIMITER ;

-- Dumping structure for function db_funkc.create_user_fn
DELIMITER //
CREATE FUNCTION `create_user_fn`(p_username VARCHAR(50), p_password_hash VARCHAR(255)) RETURNS tinyint(1)
    DETERMINISTIC
BEGIN
    DECLARE existing INT DEFAULT 0;
    SELECT COUNT(*) INTO existing FROM users WHERE username = p_username;

    IF existing = 0 THEN
        INSERT INTO users(username, password_hash) VALUES (p_username, p_password_hash);
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END IF;
END//
DELIMITER ;

-- Dumping structure for function db_funkc.delete_user_fn
DELIMITER //
CREATE FUNCTION `delete_user_fn`(p_username VARCHAR(50)) RETURNS tinyint(1)
    DETERMINISTIC
BEGIN
    IF EXISTS(SELECT 1 FROM users WHERE username = p_username) THEN
        DELETE FROM users WHERE username = p_username;
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END IF;
END//
DELIMITER ;

-- Dumping structure for function db_funkc.is_logged_in_fn
DELIMITER //
CREATE FUNCTION `is_logged_in_fn`(p_token VARCHAR(255)) RETURNS tinyint(1)
    DETERMINISTIC
BEGIN
    IF EXISTS(SELECT 1 FROM sessions WHERE token = p_token AND expires_at > NOW()) THEN
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END IF;
END//
DELIMITER ;

-- Dumping structure for function db_funkc.modify_user_fn
DELIMITER //
CREATE FUNCTION `modify_user_fn`(p_username VARCHAR(50), p_new_password_hash VARCHAR(255)) RETURNS tinyint(1)
    DETERMINISTIC
BEGIN
    IF EXISTS(SELECT 1 FROM users WHERE username = p_username) THEN
        UPDATE users SET password_hash = p_new_password_hash WHERE username = p_username;
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END IF;
END//
DELIMITER ;

-- Dumping structure for table db_funkc.sessions
CREATE TABLE IF NOT EXISTS `sessions` (
  `session_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `expires_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`session_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `sessions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_funkc.sessions: ~0 rows (approximately)
INSERT INTO `sessions` (`session_id`, `user_id`, `token`, `created_at`, `expires_at`) VALUES
	(3, 1, '2719ed15d9ab9c3d4363dc097b36f224454ef5811469c05e500b95b26fea1a42', '2026-01-27 14:44:50', '2026-01-27 15:14:50');

-- Dumping structure for table db_funkc.users
CREATE TABLE IF NOT EXISTS `users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table db_funkc.users: ~2 rows (approximately)
INSERT INTO `users` (`user_id`, `username`, `password_hash`, `created_at`) VALUES
	(1, 'test', '$2y$10$JEWEYlMRnOpou3sOw1nufOw6Myy0TVImQan0zrQAT6FqviSdL3JV.', '2026-01-27 14:29:32'),
	(2, 'monkey', '$2y$10$ZK3sIml15CH8upTFQWBmLeTxzDyPi6PLYjyAKNuMeXZUWHaQHkXE.', '2026-01-27 14:30:48');

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
