<?php
require "db.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user = $_POST['user'] ?? '';
    $pass = $_POST['pass'] ?? '';

    try {
        $stmt = $pdo->prepare("SELECT create_user(:u, :p) AS status");
        $stmt->execute([':u' => $user, ':p' => $pass]);
        $res = $stmt->fetch();

        if ($res['status'] == 1) {
            echo "<div class='msg success'>Lietotājs izveidots!</div>";
            // Pāradresē uz login
            header("Refresh:2; url=login.php");
            exit;
        } else {
            echo "<div class='msg error'>Lietotājs jau eksistē!</div>";
        }

    } catch(PDOException $e) {
        echo "<div class='msg error'>Kļūda: ".$e->getMessage()."</div>";
    }
}
?>
<!DOCTYPE html>
<html lang="lv">
<head>
<meta charset="UTF-8">
<title>Reģistrēties</title>
<style>
body {background:#f5f5f5; font-family: Arial,sans-serif;}
.login-box {width:350px;margin:7% auto;background:white;padding:30px;border-radius:10px;box-shadow:0 0 12px rgba(0,0,0,0.1);text-align:center;}
.login-box h2 {margin-bottom:20px;}
.input-group {margin:15px 0;}
input {width:90%;padding:10px;border:1px solid #ccc;border-radius:5px;font-size:15px;}
button {margin-top:15px;width:95%;padding:12px;background:#28a745;color:white;border:none;font-size:16px;border-radius:5px;cursor:pointer;}
button:hover {background:#218838;}
.msg {margin-bottom:10px;padding:10px;border-radius:4px;}
.msg.success {background:#c7ffd2;border:1px solid #00a020;}
.msg.error {background:#ffd1d1;border:1px solid #d10000;}
a {display:block;margin-top:15px;text-decoration:none;font-size:14px;}
</style>
</head>
<body>

<div class="login-box">
    <h2>Reģistrēties</h2>
    <form method="POST">
        <div class="input-group">
            <input name="user" placeholder="Lietotājvārds" required>
        </div>
        <div class="input-group">
            <input type="password" name="pass" placeholder="Parole" required>
        </div>
        <button>Reģistrēties</button>
    </form>
    <a href="login.php">Jau ir konts? Pieslēgties!</a>
</div>

</body>
</html>
