<?php
require "db.php";

// Saglabā ziņu
$msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user = $_POST['user'] ?? '';
    $pass = $_POST['pass'] ?? '';

    try {
        // Izsaucam DB funkciju login_user
        $stmt = $pdo->prepare("SELECT login_user(:u,:p) AS session_id");
        $stmt->execute([':u' => $user, ':p' => $pass]);
        $res = $stmt->fetch();

        if ($res['session_id']) {
            // Saglabā sesiju cookie
            setcookie("session", $res['session_id'], time()+7200, "/");
            header("Location: profile.php");
            exit;
        } else {
            $msg = "Nepareizs lietotājs vai parole!";
        }
    } catch(PDOException $e) {
        $msg = "Kļūda: ".$e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="lv">
<head>
<meta charset="UTF-8">
<title>Pieslēgties</title>
<style>
body {background:#f5f5f5; font-family:Arial,sans-serif;}
.login-box {width:350px;margin:7% auto;background:white;padding:30px;border-radius:10px;box-shadow:0 0 12px rgba(0,0,0,0.1);text-align:center;}
.login-box h2 {margin-bottom:20px;}
.input-group {margin:15px 0;}
input {width:90%;padding:10px;border:1px solid #ccc;border-radius:5px;font-size:15px;}
button {margin-top:15px;width:95%;padding:12px;background:#0066ff;color:white;border:none;font-size:16px;border-radius:5px;cursor:pointer;}
button:hover {background:#0050cc;}
.msg {margin-bottom:10px;padding:10px;border-radius:4px;background:#ffd1d1;border:1px solid #d10000;}
a {display:block;margin-top:15px;text-decoration:none;font-size:14px;}
</style>
</head>
<body>

<div class="login-box">
    <h2>Pieslēgties</h2>

    <?php if($msg) echo "<div class='msg'>$msg</div>"; ?>

    <form method="POST">
        <div class="input-group">
            <input name="user" placeholder="Lietotājvārds" required>
        </div>
        <div class="input-group">
            <input type="password" name="pass" placeholder="Parole" required>
        </div>
        <button>Pieslēgties</button>
    </form>
    <a href="register.php">Nav konta? Reģistrējies!</a>
</div>

</body>
</html>
