document.addEventListener("DOMContentLoaded", () => {
  const form = document.querySelector(".form");

  form.addEventListener("submit", async (e) => {
    e.preventDefault();

    const username = document.querySelector("#username").value.trim();
    const password = document.querySelector("#password").value.trim();
    const name = document.querySelector("#name").value.trim();
    const surname = document.querySelector("#surname").value.trim();

    // Validate fields
    if (!username || !password || !name || !surname) {
      alert("Lūdzu aizpildi visus laukus!");
      return;
    }

    if (username.length < 2 || username.length > 16) {
      alert("Lietotājvārdam jābūt 2–16 rakstzīmēm garam!");
      return;
    }

    if (name.length < 2 || name.length > 16) {
      alert("Vārdam jābūt 2–16 rakstzīmēm garam!");
      return;
    }

    if (surname.length < 2 || surname.length > 16) {
      alert("Uzvārdam jābūt 2–16 rakstzīmēm garam!");
      return;
    }

    if (password.length < 8 || password.length > 16) {
      alert("Parolei jābūt 8–16 rakstzīmēm garai!");
      return;
    }

    try {
      const response = await fetch("http://localhost:3000/register", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ username, password, name, surname }),
      });

      const data = await response.json();

      if (response.ok) {
        alert("Reģistrācija veiksmīga!");
        window.location.href = "login.html";
      } else {
        alert(data.message || "Reģistrācija neizdevās!");
      }
    } catch (error) {
      console.error("Kļūda:", error);
      alert("Servera kļūda. Mēģini vēlreiz vēlāk.");
    }
  });
});
