// Importējam Pool klasi no pg (PostgreSQL klienta Node.js vidē)
// Pool ļauj efektīvi pārvaldīt vairākus savienojumus ar datubāzi
const { Pool } = require('pg');

// Izveidojam savienojumu baseinu (connection pool) ar PostgreSQL datubāzi
// SVARĪGI: šis savienojums NETIEK izmantots tiešai piekļuvei tabulām
// (nav INSERT / SELECT / UPDATE uz tabulām)
//
// Backend pusē mēs drīkstam izmantot šo pool
// TIKAI, lai izsauktu PostgreSQL FUNKCIJAS,
// kā to prasa skolotāja nosacījumi
const pool = new Pool({
  // DATABASE_URL tiek ņemts no .env faila
  // Piemērs:
  // postgresql://lietotajs@localhost:5432/nazars_db
  connectionString: process.env.DATABASE_URL,
});

// Eksportējam pool objektu, lai to varētu izmantot citos backend failos
// Piemēram server.js vai API kontrolieros
// Šis pool tiks izmantots, lai izsauktu DB funkcijas
module.exports = pool;