# Lietotāju sesiju sistēma

Šis projekts realizē lietotāju pieslēgšanos un sesijas pārvaldību ar React (Vite), Node.js + Express un PostgreSQL. Visa biznesa loģika dzīvo PostgreSQL funkcijās, bet backend drīkst izsaukt tikai šīs funkcijas.

## Projekta struktūra

```
nazars-db/
  backend/
    src/
      db.js
      server.js
    .env.example
    package.json
  db/
    schema.sql
  src/
    App.jsx
    App.css
    index.css
    main.jsx
  index.html
  package.json
  vite.config.js
```

## Datubāze

1. Izveido PostgreSQL datubāzi.
2. Palaid `db/schema.sql`, lai izveidotu tabulas un funkcijas.

SQL failā ir komentāri par sesijas taimauta (2 minūtes) loģiku un par to, kāpēc biznesa loģika tiek turēta DB funkcijās.

## Backend

Backend izmanto tikai `SELECT function_name(...)` un neveic tiešu piekļuvi tabulām. Sesijas taimauts tiek pārbaudīts DB funkcijās (`is_user_logged_in`, `perform_action`).

### Konfigurācija

Izveido failu `backend/.env` pēc parauga `backend/.env.example`.

### Palaišana

```
cd backend
npm install
npm run start
```

## Frontend

React aplikācija izmanto w3.css stilu un satur divas lapas: pieslēgšanās/reģistrācijas un galveno lapu.

### Palaišana

```
npm install
npm run dev
```

Ja backend darbojas citā adresē, iestati `VITE_API_URL` (piem., `http://localhost:3001`).

## API maršruti

- `POST /register`
- `POST /login`
- `POST /logout`
- `POST /status`
- `POST /action`
