# Luksoforu Datu Bāze

Šis projekts satur datus par luksoforiem un nodrošina nepieciešamos failus, lai izveidotu datu bāzi un importētu datus.

## Projekta struktūra

- `sql/create_tables.sql`: SQL komandas, lai izveidotu nepieciešamās tabulas luksoforu datu glabāšanai.
- `data/luksofori_sample_data.csv`: Paraugu dati CSV formātā, kas atbilst `create_tables.sql` definētajai shēmai.
- `README.md`: Dokumentācija par projekta uzstādīšanu un datu importēšanu.

## Datu bāzes uzstādīšana

1. **Izveidojiet datu bāzi**:
   Izveidojiet jaunu datu bāzi, izmantojot savu datu bāzes pārvaldības sistēmu (DBMS).

2. **Izpildiet SQL skriptu**:
   Atveriet `create_tables.sql` failu un izpildiet tā saturu savā DBMS, lai izveidotu nepieciešamās tabulas.

3. **Importējiet paraugu datus**:
   Izmantojiet `luksofori_sample_data.csv` failu, lai importētu datus tabulās. Pārliecinieties, ka CSV fails ir pareizi formatēts atbilstoši tabulu shēmai.

## Datu struktūra

Tabulās tiks iekļauti šādi lauki:

- `objekta_id`: unikāls identifikators katram luksoforam
- `krustojuma_nosaukums`: nosaukums, kas identificē krustojumu
- `ielu_nosaukumi`: ielu nosaukumi, kas saistīti ar krustojumu
- `skaitītāja_nr`: skaitītāja numurs
- `uzstādīts`: datums, kad luksofors tika uzstādīts
- `demontēts`: datums, kad luksofors tika demontēts
- `zīmju_skaits`: zīmju skaits, kas saistīts ar luksoforu
- `aug`: dati par augstumu
- `jul`: dati par jūliju
- `diff`: starpība starp augstumu un jūliju

## Papildu informācija

Lūdzu, pārbaudiet `create_tables.sql` un `luksofori_sample_data.csv` failus, lai iegūtu detalizētāku informāciju par datu struktūru un paraugiem.