// Kārtošana pēc kolonnas
function sortTable(n) {
    var table = document.getElementById("luksofori");
    var rows, switching, i, x, y, shouldSwitch, dir, switchcount = 0;
    switching = true;
    dir = "asc";
    while (switching) {
        switching = false;
        rows = table.rows;
        for (i = 1; i < (rows.length - 1); i++) {
            shouldSwitch = false;
            x = rows[i].getElementsByTagName("TD")[n];
            y = rows[i + 1].getElementsByTagName("TD")[n];
            if (dir == "asc") {
                if (x.innerHTML.toLowerCase() > y.innerHTML.toLowerCase()) {
                    shouldSwitch = true;
                    break;
                }
            } else if (dir == "desc") {
                if (x.innerHTML.toLowerCase() < y.innerHTML.toLowerCase()) {
                    shouldSwitch = true;
                    break;
                }
            }
        }
        if (shouldSwitch) {
            rows[i].parentNode.insertBefore(rows[i + 1], rows[i]);
            switching = true;
            switchcount++;
        } else {
            if (switchcount == 0 && dir == "asc") {
                dir = "desc";
                switching = true;
            }
        }
    }
}

// Filtrēšana pēc kolonnas
function filterTable(col) {
    var input, filter, table, tr, td, i, txtValue;
    if (col === 1) {
        input = document.getElementById("objektsFilter");
    } else if (col === 2) {
        input = document.getElementById("numursFilter");
    }
    filter = input.value.toUpperCase();
    table = document.getElementById("luksofori");
    tr = table.getElementsByTagName("tr");
    for (i = 1; i < tr.length; i++) {
        td = tr[i].getElementsByTagName("td")[col];
        if (td) {
            txtValue = td.textContent || td.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                tr[i].style.display = "";
            } else {
                tr[i].style.display = "none";
            }
        }
    }
}

// Inicializācija, ja vajag vēlāk paplašināt
function initTable() {
    // Šeit var pievienot citas inicializācijas darbības, ja nepieciešams
}

document.getElementById('excelFile').addEventListener('change', function(e) {
    var file = e.target.files[0];
    if (!file) return;

    var reader = new FileReader();
    reader.onload = function(e) {
        var data = new Uint8Array(e.target.result);
        var workbook = XLSX.read(data, {type: 'array'});
        var firstSheet = workbook.Sheets[workbook.SheetNames[0]];
        var rows = XLSX.utils.sheet_to_json(firstSheet, {header:1});
        var tbody = document.getElementById('luksofori').getElementsByTagName('tbody')[0];

        // Notīra iepriekšējos datus
        tbody.innerHTML = '';

        // Sāk no 1. rindas, ja 0. ir virsraksti
        for (var i = 1; i < rows.length; i++) {
            var row = rows[i];
            if (!row || row.length === 0) continue;
            var tr = document.createElement('tr');
            // Pievieno visas kolonnas, kas ir failā (piemēram, arī patēriņu)
            for (var j = 0; j < row.length; j++) {
                var td = document.createElement('td');
                td.textContent = row[j] || '';
                tr.appendChild(td);
            }
            tbody.appendChild(tr);
        }
    };
    reader.readAsArrayBuffer(file);
});