<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Čata Logs</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .chat-container {
            width: 1200px;
            height: 700px;
            background: white;
            border-radius: 10px;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
            display: flex;
            flex-direction: column;
        }
        .header {
            height: 50px;
            background: #54595e;
            color: white;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 15px;
            font-size: 18px;
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
        }
        .header .user {
            display: flex;
            align-items: center;
        }
        .header .user-icon {
            width: 30px;
            height: 30px;
            background: white;
            border-radius: 50%;
            margin-left: 10px;
            display: flex;
            justify-content: center;
            align-items: center;
            color: #54595e;
        }
        .main {
            display: flex;
            flex: 1;
        }
        .sidebar {
            width: 200px;
            background: #f9f9f9;
            border-right: 1px solid #ddd;
            display: flex;
            flex-direction: column;
            padding: 10px;
        }
        .sidebar .user {
            margin: 5px 0;
            display: flex;
            align-items: center;
        }
        .sidebar .user .user-icon {
            width: 25px;
            height: 25px;
            background: #ddd;
            border-radius: 50%;
            margin-right: 10px;
        }
        .chat-box {
            flex: 1;
            padding: 15px;
            display: flex;
            flex-direction: column;
            justify-content: flex-end;
            align-items: flex-start;
            overflow-y: auto;
            position: relative;
        }
        .message {
            background: #e9e9e9;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 10px;
            position: relative;
            width: auto;
            max-width: 100%;
            word-wrap: break-word;
        }
        .message .time {
            font-size: 10px;
            color: #666;
            position: absolute;
            bottom: -15px;
            right: 10px;
        }
        .input-box {
            display: flex;
            border-top: 1px solid #ddd;
            padding: 10px;
        }
        .input-box input {
            flex: 1;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            outline: none;
        }
        .input-box button {
            margin-left: 10px;
            padding: 10px 20px;
            border: none;
            background: #54595e;
            color: white;
            border-radius: 5px;
            cursor: pointer;
        }
        .input-box button:hover {
            background: #0056b3;
        }
    </style>
</head>
<body>
    <div class="chat-container">
        <div class="header">
            <span>Čata logs</span>
            <div class="user">
                <span id="usernameDisplay">Vārds</span>
                <div class="user-icon">😊</div>
            </div>
        </div>
        <div class="main">
            <div class="sidebar" id="userList">
                <!-- Lietotāji tiks ielādēti šeit -->
            </div>
            <div class="chat-box" id="chatBox">
                <p id="placeholder">Jaunākās ziņas...</p>
            </div>
        </div>
        <div class="input-box">
            <input type="text" id="message" placeholder="Tavs teksts...">
            <button onclick="sendMessage()">Sūtīt</button>
        </div>
    </div>

    <script>
        function getQueryParam(name) {
            const urlParams = new URLSearchParams(window.location.search);
            return urlParams.get(name);
        }

        // Ziņu ielāde
        function loadMessages() {
            fetch('get_messages.php')
                .then(response => response.text())
                .then(data => {
                    document.getElementById("chatBox").innerHTML = data || '<p id="placeholder">Jaunākās ziņas...</p>';
                    var chatBox = document.getElementById("chatBox");
                    chatBox.scrollTop = chatBox.scrollHeight;
                });
        }

        function loadUsers() {
            fetch('get_users.php')
                .then(response => response.text())
                .then(data => {
                    document.getElementById("userList").innerHTML = data;
                });
        }

        // Uzstāda lietotājvārdu, ja tas ir URL
        window.onload = function() {
            var username = getQueryParam('username');
            if (username) {
                document.getElementById("usernameDisplay").textContent = username;
            }
            loadMessages();
            loadUsers();
            setInterval(loadMessages, 2000);
            setInterval(loadUsers, 5000); // lietotāju sarakstu atjauno ik pēc 5 sekundēm
        };

        function sendMessage() {
            var messageInput = document.getElementById("message");
            var messageText = messageInput.value.trim();
            if (messageText !== "") {
                var username = document.getElementById("usernameDisplay").textContent;
                var time = new Date();
                var formattedTime = time.getHours().toString().padStart(2, '0') + ":" + time.getMinutes().toString().padStart(2, '0');

                // Sūta ziņu uz serveri
                var formData = new FormData();
                formData.append('username', username);
                formData.append('message', messageText);
                formData.append('time', formattedTime);

                fetch('save_message.php', {
                    method: 'POST',
                    body: formData
                }).then(response => response.text())
                  .then(data => {
                      if (data === "OK") {
                          messageInput.value = "";
                          loadMessages();
                      } else {
                          alert("Kļūda saglabājot ziņu!");
                      }
                  });
            }
        }
    </script>
</body>
</html>
