// Ielādējam receptes no LocalStorage vai izmantojam tukšu masīvu, ja tās nav saglabātas
const recipes = JSON.parse(localStorage.getItem("recipes")) || [];

// Funkcija recepšu saglabāšanai LocalStorage
function saveRecipes() {
  localStorage.setItem("recipes", JSON.stringify(recipes));
}

// Funkcija lapu pārslēgšanai
function showPage(pageId) {
  // Paslēpjam visas lapas
  document.querySelectorAll(".page").forEach((page) => {
    page.style.display = "none";
  });

  // Parādam izvēlēto lapu
  document.getElementById(pageId).style.display = "block";

  // Ja tiek atvērta recepšu lapa, atjaunojam sarakstu
  if (pageId === "recipeList") {
    displayRecipes();
  }

  // Atjaunojam aktīvo navigācijas pogu
  document.querySelectorAll("nav button").forEach((btn) => {
    btn.classList.remove("active");
  });

  document
    .querySelector(`nav button[onclick="showPage('${pageId}')"]`)
    .classList.add("active");
}

// Apstrādājam formas iesniegšanu un pievienojam jaunu recepti
document.getElementById("recipeForm").addEventListener("submit", function (e) {
  e.preventDefault(); // Novērš lapas pārlādi

  // Iegūstam ievadītos datus
  const recipeName = document.getElementById("recipeName").value.trim();
  const ingredients = document.getElementById("ingredients").value.trim();
  const instructions = document.getElementById("instructions").value.trim();

  // Pārbaudām, vai visi lauki ir aizpildīti
  if (!recipeName || !ingredients || !instructions) {
    alert("Lūdzu, aizpildiet visus laukus.");
    return;
  }

  // Pievienojam jauno recepti masīvam
  recipes.push({ name: recipeName, ingredients, instructions });
  saveRecipes(); // Saglabājam datus LocalStorage

  this.reset(); // Notīram formu
  showPage("recipeList"); // Pārslēdzamies uz recepšu sarakstu
});

// Funkcija recepšu saraksta attēlošanai
function displayRecipes() {
  const recipeList = document.getElementById("recipes");
  recipeList.innerHTML = ""; // Notīram iepriekšējo sarakstu

  recipes.forEach((recipe, index) => {
    const listItem = document.createElement("li");
    listItem.innerHTML = `
            <span class="recipe-name" onclick="showRecipeDetails(${index})">${recipe.name}</span>
            <button class="delete-button" onclick="deleteRecipe(${index})">Dzēst</button>
        `;
    recipeList.appendChild(listItem);
  });
}

// Funkcija, lai parādītu detalizētu informāciju par recepti
function showRecipeDetails(index) {
  const recipe = recipes[index]; // Iegūstam izvēlēto recepti

  const detailsPage = document.getElementById("recipeDetails");
  detailsPage.innerHTML = `
        <h1>${recipe.name}</h1>
        <p><strong>Sastāvdaļas:</strong></p>
        <p>${recipe.ingredients}</p>
        <p><strong>Pagatavošanas instrukcijas:</strong></p>
        <p>${recipe.instructions}</p>
        <button onclick="showPage('recipeList')">Atpakaļ uz sarakstu</button>
    `;

  showPage("recipeDetails"); // Pārslēdzamies uz detalizēto skatu
}

// Funkcija receptes dzēšanai
function deleteRecipe(index) {
  if (confirm("Vai tiešām vēlaties dzēst šo recepti?")) {
    recipes.splice(index, 1); // Izņemam recepti no masīva
    saveRecipes(); // Atjaunojam LocalStorage
    displayRecipes(); // Atjaunojam sarakstu ekrānā
  }
}

// Kad lapa ielādējas, parādām sākotnējo lapu
showPage("addRecipe");
