<?php
session_start(); // Vajadzīgs savādāk nevarēs lejuplādēt kā CSV

// Extract IP from filename
function getIP($filename) {
    preg_match('/(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})/', $filename, $match);
    return $match[1] ?? ''; // Lauks tukšs ja nav IP
}

// Process file content using regex
function parseFileContent($content, $ip) {
    $pattern = '/\d{3};(\d{4})(\d{2})(\d{2}):(\d{2})(\d{2})(\d{2})([\s\n]*)(([A-Z-0-9]*):|())([A-Z-.\d]*)([DPB0-9_ \r\n]*)([\s\n]*)(([_=A-Z-0-9]*)|())([A-Za-z-0-9- \r\n]*)/m';
    preg_match_all($pattern, $content, $matches, PREG_SET_ORDER);

    if (!$matches) {
        return []; // Return an empty array if no matches found
    }

    $data = [];
    foreach ($matches as $m) {
        $data[] = [
            'IP' => $ip,
            'Date' => "{$m[1]}-{$m[2]}-{$m[3]}",
            'Time' => "{$m[4]}:{$m[5]}:{$m[6]}",
            'Code' => $m[8] ?? '',
            'Error' => $m[11] ?? '',
            'Unit' => $m[12] ?? '',
            'Object' => $m[16] ?? '',
            'Status' => $m[18] ?? '',
        ];
    }
    return $data;
}

// Generate CSV file
function exportCSV($data) {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="data_export.csv"');

    $csv = fopen('php://output', 'w');

    foreach ($data as $row) {
        // Combine all values into one single cell
        $singleCell = implode(" | ", $row); // Using " | " as a separator
        fputcsv($csv, [$singleCell]); // Writing the entire row as one cell
    }

    fclose($csv);
    exit();
}


// Handle file upload
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!empty($_FILES['file'])) {
        $fileContent = file_get_contents($_FILES['file']['tmp_name']);
        $sourceIP = getIP($_FILES['file']['name']);
        $_SESSION['data'] = parseFileContent($fileContent, $sourceIP);
    }

    if (isset($_POST['download_csv']) && !empty($_SESSION['data'])) {
        exportCSV($_SESSION['data']);
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <title>HVI Datu Apstrāde</title>
</head>
<body>
    <section>
        <h2>Augšuplādēt HVI failu</h2>
        <fieldset>
            <legend>Faila izvēle</legend>
            <form method="POST" enctype="multipart/form-data">
                <div>
                    <label for="file">Izvēlies failu:</label>
                    <input type="file" id="file" name="file" accept=".hvi,.txt" required>
                </div>
                <div>
                    <button type="submit">Augšuplādēt</button>
                </div>
            </form>
        </fieldset>
    </section>

    <?php if (!empty($_SESSION['data'])) : ?>
        <section>
            <h2>Apstrādātie dati</h2>
            <form method="POST">
                <button type="submit" name="download_csv">Lejuplādēt CSV</button>
            </form>
            <table border="1">
                <thead>
                    <tr>
                        <th>IP</th>
                        <th>Date</th>
                        <th>Time</th>
                        <th>Code</th>
                        <th>Error</th>
                        <th>Unit</th>
                        <th>Object</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($_SESSION['data'] as $row) : ?>
                    <tr>
                        <?php foreach ($row as $column) : ?>
                        <td><?= htmlspecialchars($column) ?></td>
                        <?php endforeach; ?>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </section>
    <?php endif; ?>
</body>
</html>

