<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/zinojumi.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasRole('treneris')) {
    header("Location: ../index.php");
    exit();
}

$lietotajs = $auth->getCurrentUser();
$db = Database::getInstance();
$zinojumi = new Zinojumi();

// Nosūtīt ziņojumu
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['sutit'])) {
    $kam_id = intval($_POST['kam_id']);
    $teksts = trim($_POST['teksts']);
    
    if (!empty($teksts) && $kam_id > 0) {
        $zinojumi->nosutitZinojumu($lietotajs['id'], $kam_id, $teksts);
        
        // Aktivitāšu žurnāls
        $saņēmējs = $db->izpilditVaicajumu("SELECT vards, uzvards FROM lietotaji WHERE id = ?", [$kam_id])->fetch();
        $db->izpilditVaicajumu(
            "INSERT INTO zurnals (lietotaja_id, darbiba, ip_adrese) VALUES (?, ?, ?)",
            [$lietotajs['id'], 'Nosūtīja ziņojumu: ' . $saņēmējs['vards'] . ' ' . $saņēmējs['uzvards'], $_SERVER['REMOTE_ADDR'] ?? '']
        );
        
        header("Location: zinojumi.php?ar=" . $kam_id);
        exit();
    }
}

// Iegūt visas sarunas
$sarunas = $zinojumi->iegutSarunas($lietotajs['id']);

// Iegūt visus klientus (visi reģistrētie klienti)
$visi_klienti = $db->izpilditVaicajumu("
    SELECT l.id, l.vards, l.uzvards, l.epasts
    FROM lietotaji l
    WHERE l.loma = 'klients' AND l.aktivizets = 1
    ORDER BY l.vards, l.uzvards
", [])->fetchAll();

// Filtrēt tikai tos klientus, ar kuriem vēl nav sarunas
$klienti_bez_sarakstas = [];
$sarunu_lietotaju_id = [];
foreach ($sarunas as $s) {
    $sarunu_lietotaju_id[] = $s['otra_lietotaja_id'];
}
foreach ($visi_klienti as $k) {
    if (!in_array($k['id'], $sarunu_lietotaju_id)) {
        $klienti_bez_sarakstas[] = $k;
    }
}

// Ja ir izvēlēts lietotājs
$aktivais_lietotajs = null;
$saruna = [];
if (isset($_GET['ar'])) {
    $lietotajs_id = intval($_GET['ar']);
    $aktivais_lietotajs = $db->izpilditVaicajumu("SELECT * FROM lietotaji WHERE id = ?", [$lietotajs_id])->fetch();
    
    if ($aktivais_lietotajs) {
        $saruna = $zinojumi->iegutSarunu($lietotajs['id'], $lietotajs_id);
        $zinojumi->atzimetKaIzlasitus($lietotajs_id, $lietotajs['id']);
    }
}

// Jaunas ziņas režīms
$jauna_zina = isset($_GET['jauna']);
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ziņojumi - Trenera Panelis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        .chat-container {
            height: 400px;
            overflow-y: auto;
            border: 1px solid #dee2e6;
            border-radius: 10px;
            padding: 15px;
            background: #f8f9fa;
        }
        .message {
            margin-bottom: 15px;
            padding: 10px 15px;
            border-radius: 15px;
            max-width: 70%;
        }
        .message-sent {
            background: linear-gradient(135deg, #28a745, #20c997);
            color: white;
            margin-left: auto;
        }
        .message-received {
            background: white;
            border: 1px solid #dee2e6;
        }
        .message-time {
            font-size: 0.75rem;
            opacity: 0.7;
        }
        .contact-list {
            max-height: 500px;
            overflow-y: auto;
        }
        .contact-item {
            cursor: pointer;
            transition: background 0.2s;
        }
        .contact-item:hover {
            background: #f8f9fa;
        }
        .contact-item.active {
            background: #e3f2fd;
            border-left: 3px solid #28a745;
        }
        .unread-badge {
            background: #dc3545;
            color: white;
            border-radius: 50%;
            padding: 2px 8px;
            font-size: 0.75rem;
        }
        .section-divider {
            border-top: 1px solid #dee2e6;
            margin: 10px 0;
        }
    </style>
</head>
<body>
    <?php include '../includes/header.php'; ?>

    <div class="container mt-4">
        <h1>Ziņojumi</h1>
        
        <div class="row mt-4">
            <!-- Kontaktu saraksts -->
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Sarunas</h5>
                        <a href="zinojumi.php?jauna=1" class="btn btn-success btn-sm">+ Jauna</a>
                    </div>
                    <div class="card-body contact-list p-0">
                        <!-- Esošās sarunas -->
                        <?php if (!empty($sarunas)): ?>
                            <div class="p-2 bg-light">
                                <small class="text-muted fw-bold">ESOŠĀS SARUNAS</small>
                            </div>
                            <?php foreach ($sarunas as $s): ?>
                                <?php 
                                $unread = $s['neizlasiti'] > 0;
                                ?>
                                <a href="zinojumi.php?ar=<?php echo $s['otra_lietotaja_id']; ?>" 
                                   class="contact-item d-block p-3 text-decoration-none text-dark border-bottom <?php echo ($aktivais_lietotajs && $aktivais_lietotajs['id'] == $s['otra_lietotaja_id']) ? 'active' : ''; ?>">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong><?php echo htmlspecialchars($s['vards'] . ' ' . $s['uzvards']); ?></strong>
                                            <br>
                                            <small class="text-muted"><?php echo htmlspecialchars(substr($s['pedejais_zinojums'] ?? '', 0, 25)) . (strlen($s['pedejais_zinojums'] ?? '') > 25 ? '...' : ''); ?></small>
                                        </div>
                                        <div class="text-end">
                                            <?php if ($unread): ?>
                                                <span class="unread-badge"><?php echo $s['neizlasiti']; ?></span>
                                            <?php else: ?>
                                                <small class="text-muted"><?php echo $s['pedejais_laiks'] ? date('d.m.', strtotime($s['pedejais_laiks'])) : ''; ?></small>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </a>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <div class="p-3 text-muted">Jums vēl nav nevienas sarunas.</div>
                        <?php endif; ?>
                        
                        <!-- Klienti bez sarunas -->
                        <?php if (!empty($klienti_bez_sarakstas)): ?>
                            <div class="section-divider"></div>
                            <div class="p-2 bg-light">
                                <small class="text-muted fw-bold">CITI KLIENTI</small>
                            </div>
                            <?php foreach ($klienti_bez_sarakstas as $k): ?>
                                <a href="zinojumi.php?ar=<?php echo $k['id']; ?>" 
                                   class="contact-item d-block p-3 text-decoration-none text-dark border-bottom">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong><?php echo htmlspecialchars($k['vards'] . ' ' . $k['uzvards']); ?></strong>
                                            <br>
                                            <small class="text-muted"><?php echo htmlspecialchars($k['epasts']); ?></small>
                                        </div>
                                        <span class="badge bg-secondary">Jauns</span>
                                    </div>
                                </a>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        
                        <?php if (empty($sarunas) && empty($klienti_bez_sarakstas)): ?>
                            <div class="p-3 text-muted">Sistēmā nav reģistrētu klientu.</div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <!-- Saruna / Jauna ziņa -->
            <div class="col-md-8">
                <!-- Jauna ziņa - lietotāja izvēle -->
                <?php if ($jauna_zina): ?>
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">Jauna ziņa</h5>
                                <a href="zinojumi.php" class="btn btn-secondary btn-sm">Atcelt</a>
                            </div>
                        </div>
                        <div class="card-body">
                            <h6 class="mb-3">Izvēlieties klientu:</h6>
                            <div class="list-group">
                                <?php foreach ($visi_klienti as $k): ?>
                                    <a href="zinojumi.php?ar=<?php echo $k['id']; ?>" 
                                       class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong><?php echo htmlspecialchars($k['vards'] . ' ' . $k['uzvards']); ?></strong>
                                            <br>
                                            <small class="text-muted"><?php echo htmlspecialchars($k['epasts']); ?></small>
                                        </div>
                                        <span class="badge bg-success rounded-pill">→</span>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                            <?php if (empty($visi_klienti)): ?>
                                <div class="alert alert-info">Sistēmā nav reģistrētu klientu.</div>
                            <?php endif; ?>
                        </div>
                    </div>
                
                <!-- Aktīvā saruna -->
                <?php elseif ($aktivais_lietotajs): ?>
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">Saruna ar <?php echo htmlspecialchars($aktivais_lietotajs['vards'] . ' ' . $aktivais_lietotajs['uzvards']); ?></h5>
                                <span class="badge <?php echo $aktivais_lietotajs['loma'] == 'treneris' ? 'bg-success' : 'bg-primary'; ?>">
                                    <?php echo $aktivais_lietotajs['loma'] == 'treneris' ? 'Treneris' : 'Klients'; ?>
                                </span>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="chat-container mb-3" id="chatContainer">
                                <?php if (empty($saruna)): ?>
                                    <div class="text-center text-muted py-5">
                                        <p>Saruna ir tukša. Sāciet sarunu!</p>
                                    </div>
                                <?php else: ?>
                                    <?php foreach ($saruna as $z): ?>
                                        <div class="message <?php echo $z['no_lietotaja_id'] == $lietotajs['id'] ? 'message-sent' : 'message-received'; ?>">
                                            <div><?php echo nl2br(htmlspecialchars($z['teksts'])); ?></div>
                                            <div class="message-time">
                                                <?php echo date('d.m.Y H:i', strtotime($z['nosutits'])); ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                            
                            <form method="POST" action="">
                                <input type="hidden" name="kam_id" value="<?php echo $aktivais_lietotajs['id']; ?>">
                                <div class="input-group">
                                    <textarea name="teksts" class="form-control" rows="2" placeholder="Rakstiet ziņojumu..." required></textarea>
                                    <button type="submit" name="sutit" class="btn btn-success">Sūtīt</button>
                                </div>
                            </form>
                        </div>
                    </div>
                
                <!-- Nav izvēlēts -->
                <?php else: ?>
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">Ziņojumi</h5>
                        </div>
                        <div class="card-body">
                            <div class="text-center text-muted py-5">
                                <p>Izvēlieties personu no saraksta, lai skatītu sarunu vai sāktu jaunu.</p>
                                <a href="zinojumi.php?jauna=1" class="btn btn-success">Sākt jaunu sarunu</a>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        const chatContainer = document.getElementById('chatContainer');
        if (chatContainer) {
            chatContainer.scrollTop = chatContainer.scrollHeight;
        }
    </script>
</body>
</html>
