<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/database.php';
require_once '../includes/auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasRole('treneris')) {
    header("Location: ../index.php");
    exit();
}

$db = Database::getInstance();
$current_user = $auth->getCurrentUser();

// Ielādēt nodarbības datus (tikai savas nodarbības)
$nodarbiba = null;
if (isset($_GET['id'])) {
    $stmt = $db->izpilditVaicajumu("SELECT * FROM nodarbibas WHERE id = ? AND treneris_id = ?", [$_GET['id'], $current_user['id']]);
    $nodarbiba = $stmt->fetch();
    
    if (!$nodarbiba) {
        header("Location: mans_grafiks.php");
        exit();
    }
} else {
    header("Location: mans_grafiks.php");
    exit();
}

// Apstrādāt formas iesniegšanu
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nosaukums = trim($_POST['nosaukums']);
    $apraksts = trim($_POST['apraksts']);
    $sakuma_laiks = $_POST['sakuma_laiks'];
    $beigu_laiks = $_POST['beigu_laiks'];
    $maksimalais_dalibnieku_skaits = intval($_POST['maksimalais_dalibnieku_skaits']);
    $stavoklis = $_POST['stavoklis'];
    $nepieciesamais_inventars = trim($_POST['nepieciesamais_inventars'] ?? '');
    
    // Validācija - atļaut tikai nākotnes laiku (izņemot jau esošas pagātnes nodarbības)
    $orig_sakuma_laiks = strtotime($nodarbiba['sakuma_laiks']);
    $new_sakuma_laiks = strtotime($sakuma_laiks);
    
    if (empty($nosaukums) || empty($sakuma_laiks) || empty($beigu_laiks) || $maksimalais_dalibnieku_skaits <= 0) {
        $error = "Lūdzu aizpildiet visus obligātos laukus!";
    } elseif ($orig_sakuma_laiks > time() && $new_sakuma_laiks <= time()) {
        $error = "Nodarbības sākuma laiks nevar būt pagātne vai tagadne! Lūdzu izvēlieties nākotnes laiku.";
    } elseif (strtotime($beigu_laiks) <= $new_sakuma_laiks) {
        $error = "Beigu laiks nevar būt pirms sākuma laika!";
    } else {
        try {
            $db->izpilditVaicajumu(
                "UPDATE nodarbibas SET nosaukums = ?, apraksts = ?, sakuma_laiks = ?, beigu_laiks = ?, maksimalais_dalibnieku_skaits = ?, stavoklis = ?, nepieciesamais_inventars = ? WHERE id = ? AND treneris_id = ?",
                [$nosaukums, $apraksts, $sakuma_laiks, $beigu_laiks, $maksimalais_dalibnieku_skaits, $stavoklis, $nepieciesamais_inventars, $_GET['id'], $current_user['id']]
            );
            
            // Aktivitāšu žurnāls
            $db->izpilditVaicajumu(
                "INSERT INTO zurnals (lietotaja_id, darbiba, ip_adrese) VALUES (?, ?, ?)",
                [$current_user['id'], 'Rediģēja nodarbību: ' . $nosaukums, $_SERVER['REMOTE_ADDR'] ?? '']
            );
            
            header("Location: mans_grafiks.php?success=2");
            exit();
            
        } catch (Exception $e) {
            $error = "Kļūda labojot nodarbību: " . $e->getMessage();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rediģēt nodarbību - Treneris</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <?php include '../includes/header.php'; ?>

    <div class="container mt-4">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h5 class="card-title mb-0">✏️ Rediģēt nodarbību</h5>
                    </div>
                    <div class="card-body">
                        <?php if (isset($error)): ?>
                            <div class="alert alert-danger"><?php echo $error; ?></div>
                        <?php endif; ?>
                        
                        <form method="POST">
                            <div class="mb-3">
                                <label for="nosaukums" class="form-label">Nosaukums</label>
                                <input type="text" class="form-control" id="nosaukums" name="nosaukums" 
                                       value="<?php echo htmlspecialchars($nodarbiba['nosaukums']); ?>" required>
                            </div>
                            
                            <div class="mb-3">
                                <label for="apraksts" class="form-label">Apraksts</label>
                                <textarea class="form-control" id="apraksts" name="apraksts" rows="3"><?php echo htmlspecialchars($nodarbiba['apraksts']); ?></textarea>
                            </div>
                            
                            <div class="mb-3">
                                <label for="nepieciesamais_inventars" class="form-label">Nepieciešamais inventārs</label>
                                <textarea class="form-control" id="nepieciesamais_inventars" name="nepieciesamais_inventars" rows="3" 
                                          placeholder="Uzskaitiet nepieciešamo inventāru (katru jaunā rindā)"><?php echo htmlspecialchars($nodarbiba['nepieciesamais_inventars'] ?? ''); ?></textarea>
                                <small class="text-muted">Piemērs: Yoga paklājs, Svarki 5kg, Hanteles</small>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="sakuma_laiks" class="form-label">Sākuma laiks</label>
                                    <input type="datetime-local" class="form-control" id="sakuma_laiks" name="sakuma_laiks" 
                                           value="<?php echo date('Y-m-d\TH:i', strtotime($nodarbiba['sakuma_laiks'])); ?>" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="beigu_laiks" class="form-label">Beigu laiks</label>
                                    <input type="datetime-local" class="form-control" id="beigu_laiks" name="beigu_laiks" 
                                           value="<?php echo date('Y-m-d\TH:i', strtotime($nodarbiba['beigu_laiks'])); ?>" required>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label for="maksimalais_dalibnieku_skaits" class="form-label">Maksimālais dalībnieku skaits</label>
                                <input type="number" class="form-control" id="maksimalais_dalibnieku_skaits" name="maksimalais_dalibnieku_skaits" 
                                       value="<?php echo $nodarbiba['maksimalais_dalibnieku_skaits']; ?>" min="1" required>
                            </div>
                            
                            <div class="mb-3">
                                <label for="stavoklis" class="form-label">Statuss</label>
                                <select class="form-select" id="stavoklis" name="stavoklis" required>
                                    <option value="aktīva" <?php echo $nodarbiba['stavoklis'] == 'aktīva' ? 'selected' : ''; ?>>Aktīva</option>
                                    <option value="pabeigta" <?php echo $nodarbiba['stavoklis'] == 'pabeigta' ? 'selected' : ''; ?>>Pabeigta</option>
                                    <option value="atcelta" <?php echo $nodarbiba['stavoklis'] == 'atcelta' ? 'selected' : ''; ?>>Atcelta</option>
                                </select>
                            </div>
                            
                            <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                <a href="mans_grafiks.php" class="btn btn-secondary me-md-2">Atpakaļ</a>
                                <button type="submit" class="btn btn-primary">Saglabāt izmaiņas</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
