<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/database.php';
require_once '../includes/auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasRole('treneris')) {
    header("Location: ../index.php");
    exit();
}

$lietotajs = $auth->getCurrentUser();
$db = Database::getInstance();

// Iegūt inventāra datus
$inventars = null;
if (isset($_GET['id'])) {
    // Pārbaudīt vai inventārs pieder šim trenerim
    $check = $db->izpilditVaicajumu("SELECT * FROM inventars WHERE id = ?", [$_GET['id']]);
    $inventars = $check->fetch();
    
    if (!$inventars) {
        header("Location: inventars.php");
        exit();
    }
    
    // Pārbaudīt pieeju - tikai savs inventārs vai ja nav pievienoja_id
    if (!empty($inventars['pievienoja_id']) && $inventars['pievienoja_id'] != $lietotajs['id']) {
        header("Location: inventars.php");
        exit();
    }
} else {
    header("Location: inventars.php");
    exit();
}

// Rediģēšanas funkcija
if (isset($_POST['rediģet'])) {
    $nosaukums = trim($_POST['nosaukums']);
    $apraksts = trim($_POST['apraksts']);
    $daudzums = intval($_POST['daudzums']);
    $stavoklis = $_POST['stavoklis'];
    
    // Validācija
    if (empty($nosaukums) || $daudzums < 0) {
        $error = "Lūdzu aizpildiet visus obligātos laukus!";
    } else {
        try {
            $db->izpilditVaicajumu(
                "UPDATE inventars SET nosaukums = ?, apraksts = ?, daudzums = ?, stavoklis = ? WHERE id = ?",
                [$nosaukums, $apraksts, $daudzums, $stavoklis, $_GET['id']]
            );
            
            // Žurnāls
            $db->izpilditVaicajumu(
                "INSERT INTO zurnals (lietotaja_id, darbiba, ip_adrese) VALUES (?, ?, ?)",
                [$lietotajs['id'], 'Rediģēja inventāru: ' . $nosaukums, $_SERVER['REMOTE_ADDR'] ?? '']
            );
            
            header("Location: inventars.php?success=2");
            exit();
            
        } catch (Exception $e) {
            $error = "Kļūda rediģējot inventāru!";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rediģēt inventāru - Treneris</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <?php include '../includes/header.php'; ?>

    <div class="container mt-4">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h5 class="card-title mb-0">✏️ Rediģēt inventāru</h5>
                    </div>
                    <div class="card-body">
                        <?php if (isset($error)): ?>
                            <div class="alert alert-danger"><?php echo $error; ?></div>
                        <?php endif; ?>

                        <form method="POST">
                            <div class="mb-3">
                                <label for="nosaukums" class="form-label">Nosaukums *</label>
                                <input type="text" class="form-control" id="nosaukums" name="nosaukums" 
                                       value="<?php echo htmlspecialchars($inventars['nosaukums']); ?>" required>
                            </div>
                            
                            <div class="mb-3">
                                <label for="daudzums" class="form-label">Daudzums *</label>
                                <input type="number" class="form-control" id="daudzums" name="daudzums" 
                                       value="<?php echo $inventars['daudzums']; ?>" min="0" required>
                            </div>
                            
                            <div class="mb-3">
                                <label for="stavoklis" class="form-label">Stāvoklis *</label>
                                <select class="form-select" id="stavoklis" name="stavoklis" required>
                                    <option value="labā stāvoklī" <?php echo $inventars['stavoklis'] == 'labā stāvoklī' ? 'selected' : ''; ?>>Labā stāvoklī</option>
                                    <option value="jāremontē" <?php echo $inventars['stavoklis'] == 'jāremontē' ? 'selected' : ''; ?>>Jāremontē</option>
                                    <option value="nolietots" <?php echo $inventars['stavoklis'] == 'nolietots' ? 'selected' : ''; ?>>Nolietots</option>
                                </select>
                            </div>
                            
                            <div class="mb-3">
                                <label for="apraksts" class="form-label">Apraksts</label>
                                <textarea class="form-control" id="apraksts" name="apraksts" rows="3"><?php echo htmlspecialchars($inventars['apraksts']); ?></textarea>
                            </div>
                            
                            <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                <a href="inventars.php" class="btn btn-secondary me-md-2">Atpakaļ</a>
                                <button type="submit" name="rediģet" class="btn btn-primary">Saglabāt izmaiņas</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
