<?php
session_start();
require_once '../includes/config.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasRole('treneris')) {
    header("Location: ../index.php");
    exit();
}

$lietotajs = $auth->getCurrentUser();

// Pārbaudīt vai profils ir jāaizpilda
$needs_completion = empty($lietotajs['telefons']) || empty($lietotajs['dzimsanas_datums']);

$db = Database::getInstance();

// Iestatīt laika zonu
date_default_timezone_set('Europe/Riga');
$tagad = date('Y-m-d H:i:s');

// Iegūstam tikai aktīvas nodarbības, kas vēl nav sākušās
$sql = "SELECT * FROM nodarbibas WHERE treneris_id = ? AND sakuma_laiks > ? AND stavoklis = 'aktīva' ORDER BY sakuma_laiks LIMIT 5";
$nodarbibas = $db->izpilditVaicajumu($sql, [$lietotajs['id'], $tagad])->fetchAll();
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Trenera Panelis - Sporta Zāle</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <?php include '../includes/header.php'; ?>

    <div class="container mt-4">
        <h1>Trenera Panelis</h1>
        
        <?php if ($needs_completion): ?>
        <div class="alert alert-warning alert-dismissible fade show mt-4" role="alert">
            <strong>Jūsu profils nav pilnīgs!</strong> Lūdzu, aizpildiet savus kontaktinformācijas datus.
            <a href="profils.php" class="btn btn-sm btn-warning">Aizpildīt profilu</a>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php endif; ?>
        
        <!-- Gaidāmās nodarbības -->
        <div class="row mt-4">
            <div class="col-12">
                <h3>Jūsu gaidāmās nodarbības</h3>
                <?php if (empty($nodarbibas)): ?>
                    <div class="alert alert-info">
                        Jums nav gaidāmo nodarbību.
                    </div>
                <?php else: ?>
                    <div class="row">
                        <?php foreach ($nodarbibas as $nodarbiba): ?>
                            <div class="col-md-6 mb-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title"><?php echo htmlspecialchars($nodarbiba['nosaukums']); ?></h5>
                                        <p class="card-text">
                                            <strong>Laiks:</strong> <?php echo date('d.m.Y H:i', strtotime($nodarbiba['sakuma_laiks'])); ?><br>
                                            <strong>Apraksts:</strong> <?php echo htmlspecialchars($nodarbiba['apraksts']); ?>
                                        </p>
                                        <a href="mans_grafiks.php" class="btn btn-primary btn-sm">Skatīt vairāk</a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Ātrās darbības -->
        <div class="row mt-4">
            <div class="col-12">
                <h3>Ātrās darbības</h3>
                <div class="row mt-3">
                    <div class="col-md-3 mb-2">
                        <a href="pievienot_nodarbibu.php" class="btn btn-outline-primary w-100">Pievienot nodarbību</a>
                    </div>
                    <div class="col-md-3 mb-2">
                        <a href="zinojumi.php" class="btn btn-outline-info w-100">Ziņojumi</a>
                    </div>
                    <div class="col-md-3 mb-2">
                        <a href="inventars.php" class="btn btn-outline-warning w-100">Inventārs</a>
                    </div>
                    <div class="col-md-3 mb-2">
                        <a href="../dashboard.php" class="btn btn-outline-secondary w-100">Dashboard</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>