<?php
require_once 'includes/config.php';
if (isset($_SESSION['lietotaja_id'])) {
    header("Location: dashboard.php");
    exit();
}

$kļūda = '';
$veiksme = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $vards = trim($_POST['vards']);
    $uzvards = trim($_POST['uzvards']);
    $epasts = trim($_POST['epasts']);
    $parole = $_POST['parole'];
    $atkartota_parole = $_POST['atkartota_parole'];
    
    // Validācija
    if (empty($vards) || empty($uzvards) || empty($epasts) || empty($parole)) {
        $kļūda = "Lūdzu, aizpildiet visus laukus!";
    } elseif (!filter_var($epasts, FILTER_VALIDATE_EMAIL)) {
        $kļūda = "Lūdzu, ievadiet derīgu e-pasta adresi!";
    } elseif ($parole !== $atkartota_parole) {
        $kļūda = "Paroles nesakrīt!";
    } elseif (strlen($parole) < 6) {
        $kļūda = "Parolei jābūt vismaz 6 simbolus garai!";
    } else {
        $user = new User();
        if ($user->registretLietotaju($vards, $uzvards, $epasts, $parole)) {
            $veiksme = "Konts veiksmīgi izveidots! Varat pieslēgties.";
        } else {
            $kļūda = "E-pasts jau ir reģistrēts!";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reģistrācija - Sporta Zāle</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="login-body">
    <div class="container-fluid h-100">
        <div class="row h-100 justify-content-center align-items-center">
            <div class="col-12 col-md-6 col-lg-4">
                <div class="login-card">
                    <div class="text-center mb-4">
                        <div class="logo-container">
                            <span class="logo-icon">💪</span>
                            <h1 class="h3 fw-bold">Reģistrācija</h1>
                        </div>
                        <p class="text-muted">Izveidojiet savu kontu</p>
                    </div>

                    <?php if ($kļūda): ?>
                        <div class="alert alert-danger"><?php echo $kļūda; ?></div>
                    <?php endif; ?>
                    
                    <?php if ($veiksme): ?>
                        <div class="alert alert-success"><?php echo $veiksme; ?></div>
                    <?php endif; ?>

                    <form method="POST" action="">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="vards" class="form-label">Vārds</label>
                                <input type="text" class="form-control" id="vards" name="vards" 
                                       value="<?php echo isset($_POST['vards']) ? htmlspecialchars($_POST['vards']) : ''; ?>" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="uzvards" class="form-label">Uzvārds</label>
                                <input type="text" class="form-control" id="uzvards" name="uzvards"
                                       value="<?php echo isset($_POST['uzvards']) ? htmlspecialchars($_POST['uzvards']) : ''; ?>" required>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="epasts" class="form-label">E-pasts</label>
                            <input type="email" class="form-control" id="epasts" name="epasts"
                                   value="<?php echo isset($_POST['epasts']) ? htmlspecialchars($_POST['epasts']) : ''; ?>" required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="parole" class="form-label">Parole</label>
                            <input type="password" class="form-control" id="parole" name="parole" required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="atkartota_parole" class="form-label">Atkārtot paroli</label>
                            <input type="password" class="form-control" id="atkartota_parole" name="atkartota_parole" required>
                        </div>

                        <button type="submit" class="btn btn-primary btn-lg w-100 mb-3">
                            Reģistrēties
                        </button>
                    </form>

                    <div class="text-center">
                        <a href="index.php" class="text-decoration-none">Jau ir konts? Pieslēgties</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>