<?php
session_start();
require_once '../includes/config.php';

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    header("Location: ../index.php");
    exit();
}

$lietotajs = $auth->getCurrentUser();
$db = Database::getInstance();

// Pārbaudīt vai lietotājam ir jāaizpilda profils
$needs_completion = empty($lietotajs['telefons']) || empty($lietotajs['dzimsanas_datums']);

// Apstrādāt formas iesniegšanu
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $vards = trim($_POST['vards'] ?? '');
    $uzvards = trim($_POST['uzvards'] ?? '');
    $telefons = trim($_POST['telefons'] ?? '');
    $dzimsanas_datums = $_POST['dzimsanas_datums'] ?? '';
    
    $errors = [];
    
    if (empty($vards)) {
        $errors[] = "Vārds ir obligāts lauks.";
    }
    if (empty($uzvards)) {
        $errors[] = "Uzvārds ir obligāts lauks.";
    }
    
    // Paroles maiņa (ja norādīta)
    $jauna_parole = $_POST['jauna_parole'] ?? '';
    $jauna_parole_atterojumi = $_POST['jauna_parole_atterojumi'] ?? '';
    $tagadeja_parole = $_POST['tagadeja_parole'] ?? '';
    
    if (!empty($jauna_parole) || !empty($jauna_parole_atterojumi) || !empty($tagadeja_parole)) {
        // Ja kaut kas ir aizpildīts, tad visam jābūt aizpildītam
        if (empty($tagadeja_parole)) {
            $errors[] = "Lūdzu, ievadiet esošo paroli, lai to mainītu.";
        }
        if (empty($jauna_parole)) {
            $errors[] = "Lūdzu, ievadiet jauno paroli.";
        }
        if (empty($jauna_parole_atterojumi)) {
            $errors[] = "Lūdzu, atkārtoti ievadiet jauno paroli.";
        }
        if ($jauna_parole !== $jauna_parole_atterojumi) {
            $errors[] = "Jaunās paroles nesakrīt.";
        }
        if (strlen($jauna_parole) < 6) {
            $errors[] = "Jaunajai parolei jābūt vismaz 6 rakstzīmēm garai.";
        }
        
        // Pārbaudīt esošo paroli
        if (!empty($tagadeja_parole) && !empty($jauna_parole)) {
            $lietotajs_info = $db->izpilditVaicajumu("SELECT parole FROM lietotaji WHERE id = ?", [$lietotajs['id']])->fetch();
            if (!$lietotajs_info || !password_verify($tagadeja_parole, $lietotajs_info['parole'])) {
                $errors[] = "Nepareiza esošā parole.";
            }
        }
    }
    
    if (empty($errors)) {
        // Atjaunināt lietotāja datus
        $sql = "UPDATE lietotaji SET vards = ?, uzvards = ?, telefons = ?, dzimsanas_datums = ?";
        $params = [$vards, $uzvards, $telefons, $dzimsanas_datums];
        
        // Ja parole tika mainīta, pievienot to vaicājumam
        if (!empty($jauna_parole) && !empty($tagadeja_parole) && $jauna_parole === $jauna_parole_atterojumi) {
            $sql .= ", parole = ?";
            $params[] = password_hash($jauna_parole, PASSWORD_DEFAULT);
        }
        
        $sql .= " WHERE id = ?";
        $params[] = $lietotajs['id'];
        
        $db->izpilditVaicajumu($sql, $params);
        
        // Atjaunot sesiju ar jaunajiem datiem
        $atjaunotais = $db->izpilditVaicajumu("SELECT * FROM lietotaji WHERE id = ?", [$lietotajs['id']])->fetch();
        $_SESSION['lietotajs'] = $atjaunotais;
        
        // Aktivitāšu žurnāls
        $db->izpilditVaicajumu(
            "INSERT INTO zurnals (lietotaja_id, darbiba, ip_adrese) VALUES (?, ?, ?)",
            [$lietotajs['id'], 'Atjaunoja profilu', $_SERVER['REMOTE_ADDR'] ?? '']
        );
        
        $_SESSION['veiksme'] = "Profils veiksmīgi atjaunots!";
        
        // Novirzīt atbilstoši lomai
        if ($lietotajs['loma'] === 'administrators') {
            header("Location: ../admin/index.php");
        } elseif ($lietotajs['loma'] === 'treneris') {
            header("Location: ../treneris/index.php");
        } else {
            header("Location: ../klients/index.php");
        }
        exit();
    }
}
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profils - Sporta Zāle</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <?php include '../includes/header.php'; ?>

    <div class="container mt-4">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h4 class="mb-0">
                            <?php if ($needs_completion): ?>
                                <span class="badge bg-warning text-dark">Jāaizpilda</span>
                            <?php endif; ?>
                            Mans profils
                        </h4>
                    </div>
                    <div class="card-body">
                        <?php if (isset($errors) && !empty($errors)): ?>
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    <?php foreach ($errors as $error): ?>
                                        <li><?php echo $error; ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (isset($_SESSION['veiksme'])): ?>
                            <div class="alert alert-success"><?php echo $_SESSION['veiksme']; unset($_SESSION['veiksme']); ?></div>
                        <?php endif; ?>
                        
                        <?php if ($needs_completion): ?>
                            <div class="alert alert-info">
                                <strong>Piezīme:</strong> Lūdzu, aizpildiet savu profilu ar papildus informāciju.
                            </div>
                        <?php endif; ?>
                        
                        <form method="POST">
                            <!-- Lietotāja dati -->
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="vards" class="form-label">Vārds *</label>
                                    <input type="text" class="form-control" id="vards" name="vards" 
                                           value="<?php echo htmlspecialchars($lietotajs['vards'] ?? ''); ?>" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="uzvards" class="form-label">Uzvārds *</label>
                                    <input type="text" class="form-control" id="uzvards" name="uzvards" 
                                           value="<?php echo htmlspecialchars($lietotajs['uzvards'] ?? ''); ?>" required>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label for="epasts" class="form-label">E-pasts</label>
                                <input type="email" class="form-control" id="epasts" 
                                       value="<?php echo htmlspecialchars($lietotajs['epasts'] ?? ''); ?>" disabled>
                                <div class="form-text">E-pastu nevar mainīt.</div>
                            </div>
                            
                            <div class="mb-3">
                                <label for="telefons" class="form-label">Telefona numurs</label>
                                <input type="tel" class="form-control" id="telefons" name="telefons" 
                                       value="<?php echo htmlspecialchars($lietotajs['telefons'] ?? ''); ?>"
                                       placeholder="+371 12345678">
                            </div>
                            
                            <div class="mb-3">
                                <label for="dzimsanas_datums" class="form-label">Dzimšanas datums</label>
                                <input type="date" class="form-control" id="dzimsanas_datums" name="dzimsanas_datums" 
                                       value="<?php echo htmlspecialchars($lietotajs['dzimsanas_datums'] ?? ''); ?>">
                            </div>
                            
                            <!-- Paroles maiņa -->
                            <hr class="my-4">
                            <h5>Paroles maiņa</h5>
                            <p class="text-muted small">Atstājiet tukšu, ja nevēlaties mainīt paroli.</p>
                            
                            <div class="mb-3">
                                <label for="tagadeja_parole" class="form-label">Esošā parole</label>
                                <input type="password" class="form-control" id="tagadeja_parole" name="tagadeja_parole" 
                                       placeholder="Ievadiet esošo paroli">
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="jauna_parole" class="form-label">Jaunā parole</label>
                                    <input type="password" class="form-control" id="jauna_parole" name="jauna_parole" 
                                           placeholder="Ievadiet jauno paroli">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="jauna_parole_atterojumi" class="form-label">Jaunā parole atkārtoti</label>
                                    <input type="password" class="form-control" id="jauna_parole_atterojumi" name="jauna_parole_atterojumi" 
                                           placeholder="Atkārtoti ievadiet jauno paroli">
                                </div>
                            </div>
                            
                            <div class="d-flex justify-content-between">
                                <a href="
                                    <?php 
                                    if ($lietotajs['loma'] === 'administrators') {
                                        echo '../admin/index.php';
                                    } elseif ($lietotajs['loma'] === 'treneris') {
                                        echo '../treneris/index.php';
                                    } else {
                                        echo '../klients/index.php';
                                    }
                                    ?>
                                " class="btn btn-secondary">Atpakaļ</a>
                                <button type="submit" class="btn btn-primary">Saglabāt</button>
                            </div>
                        </form>
                    </div>
                </div>
                
                <!-- Konta informācija -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="mb-0">Konta informācija</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <p><strong>Loma:</strong> 
                                    <?php
                                    $role_text = 'Klients';
                                    $role_class = 'bg-primary';
                                    if ($lietotajs['loma'] === 'administrators') {
                                        $role_text = 'Administrators';
                                        $role_class = 'bg-danger';
                                    } elseif ($lietotajs['loma'] === 'treneris') {
                                        $role_text = 'Treneris';
                                        $role_class = 'bg-success';
                                    }
                                    ?>
                                    <span class="badge <?php echo $role_class; ?>"><?php echo $role_text; ?></span>
                                </p>
                                <p><strong>Konts izveidots:</strong> <?php echo date('d.m.Y', strtotime($lietotajs['izveidots'])); ?></p>
                                <p><strong>Pēdējā atjaunošana:</strong> <?php echo date('d.m.Y H:i', strtotime($lietotajs['atjauninats'])); ?></p>
                            </div>
                            <div class="col-md-6">
                                <?php if ($lietotajs['loma'] === 'klients'): ?>
                                    <p><strong>Kopējais pierakstu skaits:</strong> 
                                        <?php
                                        $pieraksti = $db->izpilditVaicajumu("SELECT COUNT(*) FROM pieraksti WHERE lietotaja_id = ?", [$lietotajs['id']])->fetch()['COUNT(*)'];
                                        echo $pieraksti;
                                        ?>
                                    </p>
                                <?php endif; ?>
                                <p><strong>Konta statuss:</strong> 
                                    <span class="badge <?php echo $lietotajs['aktivizets'] ? 'bg-success' : 'bg-danger'; ?>">
                                        <?php echo $lietotajs['aktivizets'] ? 'Aktīvs' : 'Neaktīvs'; ?>
                                    </span>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
