<?php
session_start();
require_once '../includes/config.php';

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    header("Location: ../index.php");
    exit();
}

$lietotajs = $auth->getCurrentUser();
$db = Database::getInstance();

// Iestatīt laika zonu
date_default_timezone_set('Europe/Riga');
$tagad = date('Y-m-d H:i:s');

// Iegūt pagjušās nodarbības, kurās klients ir piedalījies
// Rādīt arī nodarbības, kas nav sākušās, bet treneris tās ir atzīmējis kā pabeigtas
$vesture_sql = "SELECT n.*, l.vards AS trenera_vards, l.uzvards AS trenera_uzvards,
                       p.pieraksta_datums, p.stavoklis AS pieraksta_stavoklis
                FROM pieraksti p
                LEFT JOIN nodarbibas n ON p.nodarbibas_id = n.id
                LEFT JOIN lietotaji l ON n.treneris_id = l.id
                WHERE p.lietotaja_id = ? AND (n.sakuma_laiks <= ? OR n.stavoklis = 'pabeigta')
                ORDER BY n.sakuma_laiks DESC";
$vesture = $db->izpilditVaicajumu($vesture_sql, [$lietotajs['id'], $tagad])->fetchAll();

// Statistika
$kopējais_skaits = count($vesture);
$pabeigts_skaits = count(array_filter($vesture, function($v) {
    return $v['pieraksta_stavoklis'] == 'pabeigts' || $v['pieraksta_stavoklis'] == 'apstiprināts';
}));
$atcelti_skaits = count(array_filter($vesture, function($v) {
    return $v['pieraksta_stavoklis'] == 'atcelts';
}));
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nodarbību vēsture - Klienta Panelis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <?php include '../includes/header.php'; ?>

    <div class="container mt-4">
        <h1>Manas nodarbību vēsture</h1>
        
        <!-- Statistika -->
        <div class="row mt-4">
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-primary">
                    <div class="card-body">
                        <h5 class="card-title">Kopējais skaits</h5>
                        <p class="card-text display-6"><?php echo $kopējais_skaits; ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-success">
                    <div class="card-body">
                        <h5 class="card-title">Apmeklētās nodarbības</h5>
                        <p class="card-text display-6"><?php echo $pabeigts_skaits; ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-secondary">
                    <div class="card-body">
                        <h5 class="card-title">Atceltās nodarbības</h5>
                        <p class="card-text display-6"><?php echo $atcelti_skaits; ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Vēsture -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Nodarbību vēsture</h5>
                    </div>
                    <div class="card-body">
                        <?php if (empty($vesture)): ?>
                            <div class="alert alert-info">
                                <p>Jums vēl nav bijusi neviena nodarbību vēsture.</p>
                                <a href="nodarbibas.php" class="btn btn-primary">Pieteikties uz nodarbību</a>
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>Nodarbība</th>
                                            <th>Treneris</th>
                                            <th>Laiks</th>
                                            <th>Statuss</th>
                                            <th>Pierakstīšanās</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($vesture as $v): ?>
                                            <tr>
                                                <td>
                                                    <strong><?php echo htmlspecialchars($v['nosaukums']); ?></strong>
                                                    <br>
                                                    <small class="text-muted"><?php echo htmlspecialchars($v['apraksts']); ?></small>
                                                </td>
                                                <td><?php echo htmlspecialchars($v['trenera_vards'] . ' ' . $v['trenera_uzvards']); ?></td>
                                                <td><?php echo date('d.m.Y H:i', strtotime($v['sakuma_laiks'])); ?></td>
                                                <td>
                                                    <?php
                                                    $status_class = 'bg-secondary';
                                                    $status_text = $v['pieraksta_stavoklis'];
                                                    if ($v['pieraksta_stavoklis'] == 'pabeigts' || $v['pieraksta_stavoklis'] == 'apstiprināts') {
                                                        $status_class = 'bg-success';
                                                    } elseif ($v['pieraksta_stavoklis'] == 'atcelts') {
                                                        $status_class = 'bg-danger';
                                                    }
                                                    ?>
                                                    <span class="badge <?php echo $status_class; ?>"><?php echo $status_text; ?></span>
                                                </td>
                                                <td><?php echo date('d.m.Y H:i', strtotime($v['pieraksta_datums'])); ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Nesenās nodarbības (pēdējās 5) -->
        <div class="row mt-4">
            <div class="col-12">
                <h3>Nesenās nodarbības</h3>
                <?php if (empty($vesture)): ?>
                    <div class="alert alert-info">Nav nesenās nodarbības.</div>
                <?php else: ?>
                    <div class="row">
                        <?php foreach (array_slice($vesture, 0, 5) as $v): ?>
                            <div class="col-md-6 col-lg-4 mb-3">
                                <div class="card h-100">
                                    <div class="card-header d-flex justify-content-between align-items-center">
                                        <span><?php echo htmlspecialchars($v['nosaukums']); ?></span>
                                        <?php if ($v['pieraksta_stavoklis'] == 'apstiprināts'): ?>
                                            <span class="badge bg-success">Apmeklēta</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">Atcelta</span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="card-body">
                                        <p class="card-text">
                                            <strong>Treneris:</strong> <?php echo htmlspecialchars($v['trenera_vards'] . ' ' . $v['trenera_uzvards']); ?><br>
                                            <strong>Datums:</strong> <?php echo date('d.m.Y', strtotime($v['sakuma_laiks'])); ?><br>
                                            <strong>Laiks:</strong> <?php echo date('H:i', strtotime($v['sakuma_laiks'])); ?> - <?php echo date('H:i', strtotime($v['beigu_laiks'])); ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
