<?php
session_start();
require_once '../includes/config.php';

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    header("Location: ../index.php");
    exit();
}

$lietotajs = $auth->getCurrentUser();
$db = Database::getInstance();

// Iestatīt laika zonu PHP pusē
date_default_timezone_set('Europe/Riga');
$tagad = date('Y-m-d H:i:s');

$sql = "SELECT n.*, l.vards AS trenera_vards, l.uzvards AS trenera_uzvards,
               (SELECT COUNT(*) FROM pieraksti p WHERE p.nodarbibas_id = n.id) AS pierakstu_skaits,
               EXISTS(SELECT 1 FROM pieraksti p WHERE p.lietotaja_id = ? AND p.nodarbibas_id = n.id) AS esmu_pierakstijies
        FROM nodarbibas n
        LEFT JOIN lietotaji l ON n.treneris_id = l.id
        WHERE n.sakuma_laiks > ? AND n.stavoklis = 'aktīva'
        ORDER BY n.sakuma_laiks";
$nodarbibas = $db->izpilditVaicajumu($sql, [$lietotajs['id'], $tagad])->fetchAll();

// Iegūt inventāru katrai nodarbībai
foreach ($nodarbibas as &$nodarbiba) {
    try {
        $nodarbiba['inventars'] = $db->izpilditVaicajumu(
            "SELECT i.nosaukums, ni.daudzums FROM nodarbibas_inventars ni
             JOIN inventars i ON ni.inventara_id = i.id
             WHERE ni.nodarbibas_id = ?",
            [$nodarbiba['id']]
        )->fetchAll();
    } catch (Exception $e) {
        $nodarbiba['inventars'] = [];
    }
}

if (isset($_POST['pierakstities'])) {
    $nodarbibas_id = $_POST['nodarbibas_id'];

    $vietas_sql = "SELECT COUNT(*) as skaits FROM pieraksti WHERE nodarbibas_id = ?";
    $pierakstu_skaits = $db->izpilditVaicajumu($vietas_sql, [$nodarbibas_id])->fetch()['skaits'];
    $nodarbiba = $db->izpilditVaicajumu("SELECT maksimalais_dalibnieku_skaits FROM nodarbibas WHERE id = ?", [$nodarbibas_id])->fetch();
    
    if ($pierakstu_skaits < $nodarbiba['maksimalais_dalibnieku_skaits']) {
        $pievienot_sql = "INSERT INTO pieraksti (lietotaja_id, nodarbibas_id) VALUES (?, ?)";
        $db->izpilditVaicajumu($pievienot_sql, [$lietotajs['id'], $nodarbibas_id]);
        
        // Aktivitāšu žurnāls - pierakstīšanās uz nodarbību
        $nodarbiba_info = $db->izpilditVaicajumu("SELECT nosaukums FROM nodarbibas WHERE id = ?", [$nodarbibas_id])->fetch();
        $db->izpilditVaicajumu(
            "INSERT INTO zurnals (lietotaja_id, darbiba, ip_adrese) VALUES (?, ?, ?)",
            [$lietotajs['id'], 'Pierakstījās uz nodarbību: ' . $nodarbiba_info['nosaukums'], $_SERVER['REMOTE_ADDR'] ?? '']
        );
        
        $_SESSION['veiksme'] = "Veiksmīgi pierakstījāties uz nodarbību!";
        header("Location: nodarbibas.php");
        exit();
    } else {
        $_SESSION['kluda'] = "Nav brīvu vietu šai nodarbībai!";
    }
}

// Izrakstīšanās no nodarbības
if (isset($_POST['izrakstities'])) {
    $nodarbibas_id = $_POST['nodarbibas_id'];
    
    // Iegūt nodarbības nosaukumu pirms dzēšanas
    $nodarbiba_info = $db->izpilditVaicajumu("SELECT nosaukums FROM nodarbibas WHERE id = ?", [$nodarbibas_id])->fetch();
    
    $dzest_sql = "DELETE FROM pieraksti WHERE lietotaja_id = ? AND nodarbibas_id = ?";
    $db->izpilditVaicajumu($dzest_sql, [$lietotajs['id'], $nodarbibas_id]);
    
    // Aktivitāšu žurnāls - izrakstīšanās no nodarbības
    $db->izpilditVaicajumu(
        "INSERT INTO zurnals (lietotaja_id, darbiba, ip_adrese) VALUES (?, ?, ?)",
        [$lietotajs['id'], 'Izrakstījās no nodarbības: ' . $nodarbiba_info['nosaukums'], $_SERVER['REMOTE_ADDR'] ?? '']
    );
    
    $_SESSION['veiksme'] = "Veiksmīgi izrakstījāties no nodarbības!";
    header("Location: nodarbibas.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nodarbības - Klienta Panelis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <?php include '../includes/header.php'; ?>

    <div class="container mt-4">
        <h1>Pieejamās Nodarbības</h1>
        
        <?php if (isset($_SESSION['veiksme'])): ?>
            <div class="alert alert-success"><?php echo $_SESSION['veiksme']; unset($_SESSION['veiksme']); ?></div>
        <?php endif; ?>
        
        <?php if (isset($_SESSION['kluda'])): ?>
            <div class="alert alert-danger"><?php echo $_SESSION['kluda']; unset($_SESSION['kluda']); ?></div>
        <?php endif; ?>

        <div class="row mt-4">
            <?php if (empty($nodarbibas)): ?>
                <div class="col-12">
                    <div class="alert alert-info">
                        Šobrīd nav pieejamu nodarbību.
                    </div>
                </div>
            <?php else: ?>
                <?php foreach ($nodarbibas as $nodarbiba): ?>
                    <div class="col-md-6 col-lg-4 mb-4">
                        <div class="card h-100">
                            <div class="card-header">
                                <h5 class="card-title mb-0"><?php echo htmlspecialchars($nodarbiba['nosaukums']); ?></h5>
                            </div>
                            <div class="card-body">
                                <p class="card-text"><?php echo htmlspecialchars($nodarbiba['apraksts']); ?></p>
                                <p class="card-text">
                                    <strong>Treneris:</strong> <?php echo htmlspecialchars($nodarbiba['trenera_vards'] . ' ' . $nodarbiba['trenera_uzvards']); ?><br>
                                    <strong>Laiks:</strong> <?php echo date('d.m.Y H:i', strtotime($nodarbiba['sakuma_laiks'])); ?><br>
                                    <strong>Brīvas vietas:</strong> <?php echo ($nodarbiba['maksimalais_dalibnieku_skaits'] - $nodarbiba['pierakstu_skaits']); ?>
                                </p>
                                <?php if (!empty($nodarbiba['inventars'])): ?>
                                    <p class="card-text mt-2">
                                        <small class="text-muted">
                                            <strong>Nepieciešamais inventārs:</strong><br>
                                            <?php foreach ($nodarbiba['inventars'] as $inv): ?>
                                                • <?php echo htmlspecialchars($inv['nosaukums']); ?>
                                                <?php if ($inv['daudzums'] > 1): ?>
                                                    (x<?php echo $inv['daudzums']; ?>)
                                                <?php endif; ?><br>
                                            <?php endforeach; ?>
                                        </small>
                                    </p>
                                <?php endif; ?>
                            </div>
                            <div class="card-footer">
                                <?php if ($nodarbiba['esmu_pierakstijies']): ?>
                                    <form method="POST" class="d-inline w-100">
                                        <input type="hidden" name="nodarbibas_id" value="<?php echo $nodarbiba['id']; ?>">
                                        <button type="submit" name="izrakstities" class="btn btn-danger w-100" 
                                                onclick="return confirm('Vai tiešām vēlaties izrakstīties no šīs nodarbības?')">
                                            Izrakstīties
                                        </button>
                                    </form>
                                <?php elseif (($nodarbiba['maksimalais_dalibnieku_skaits'] - $nodarbiba['pierakstu_skaits']) > 0): ?>
                                    <form method="POST" class="d-inline w-100">
                                        <input type="hidden" name="nodarbibas_id" value="<?php echo $nodarbiba['id']; ?>">
                                        <button type="submit" name="pierakstities" class="btn btn-primary w-100">Pierakstīties</button>
                                    </form>
                                <?php else: ?>
                                    <button class="btn btn-secondary w-100" disabled>Nav brīvu vietu</button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>