<?php
session_start();
require_once '../includes/config.php';

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    header("Location: ../index.php");
    exit();
}

$lietotajs = $auth->getCurrentUser();

// Pārbaudīt vai profils ir jāaizpilda
$needs_completion = empty($lietotajs['telefons']) || empty($lietotajs['dzimsanas_datums']);

$db = Database::getInstance();

// Iestatīt laika zonu
date_default_timezone_set('Europe/Riga');
$tagad = date('Y-m-d H:i:s');

// Iegūstam nākamās nodarbības (tikai aktīvas, kas vēl nav sākušās)
$sql = "SELECT n.*, l.vards AS trenera_vards, l.uzvards AS trenera_uzvards 
        FROM pieraksti p 
        LEFT JOIN nodarbibas n ON p.nodarbibas_id = n.id 
        LEFT JOIN lietotaji l ON n.treneris_id = l.id 
        WHERE p.lietotaja_id = ? AND n.sakuma_laiks > ? AND n.stavoklis = 'aktīva'
        ORDER BY n.sakuma_laiks LIMIT 3";
$nodarbibas = $db->izpilditVaicajumu($sql, [$lietotajs['id'], $tagad])->fetchAll();

// Kopējais pierakstu skaits
$kopais_pieraksti = $db->izpilditVaicajumu("
    SELECT COUNT(*) as skaits FROM pieraksti WHERE lietotaja_id = ?
", [$lietotajs['id']])->fetch()['skaits'];

// Iepriekšējās nodarbības (ieskaitot pabeigtas, pat ja laiks vēl nav pagājis)
$ieprieksejas_nodarbibas = $db->izpilditVaicajumu("
    SELECT COUNT(*) as skaits FROM pieraksti p 
    LEFT JOIN nodarbibas n ON p.nodarbibas_id = n.id 
    WHERE p.lietotaja_id = ? AND (n.sakuma_laiks <= ? OR n.stavoklis = 'pabeigta')
", [$lietotajs['id'], $tagad])->fetch()['skaits'];
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Klients - Sporta Zāle</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <?php include '../includes/header.php'; ?>

    <div class="container mt-4">
        <h1>Klients Panelis</h1>
        
        <?php if ($needs_completion): ?>
        <div class="alert alert-warning alert-dismissible fade show mt-4" role="alert">
            <strong>Jūsu profils nav pilnīgs!</strong> Lūdzu, aizpildiet savus kontaktinformācijas datus.
            <a href="profils.php" class="btn btn-sm btn-warning">Aizpildīt profilu</a>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php endif; ?>
        
        <!-- Ātrā statistika -->
        <div class="row mt-4">
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-primary">
                    <div class="card-body">
                        <h5 class="card-title">Kopējais pierakstu skaits</h5>
                        <p class="card-text display-6"><?php echo $kopais_pieraksti; ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-success">
                    <div class="card-body">
                        <h5 class="card-title">Nākamās nodarbības</h5>
                        <p class="card-text display-6"><?php echo count($nodarbibas); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-secondary">
                    <div class="card-body">
                        <h5 class="card-title">Apmeklētās nodarbības</h5>
                        <p class="card-text display-6"><?php echo $ieprieksejas_nodarbibas; ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Nākamās nodarbības -->
        <div class="row mt-4">
            <div class="col-12">
                <h3>Jūsu nākamās nodarbības</h3>
                <?php if (empty($nodarbibas)): ?>
                    <div class="alert alert-info">
                        Jums nav gaidāmo nodarbību.
                        <a href="nodarbibas.php" class="alert-link">Pieteikties uz nodarbību</a>
                    </div>
                <?php else: ?>
                    <div class="row">
                        <?php foreach ($nodarbibas as $nodarbiba): ?>
                            <div class="col-md-4 mb-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title"><?php echo htmlspecialchars($nodarbiba['nosaukums']); ?></h5>
                                        <p class="card-text">
                                            <strong>Treneris:</strong> <?php echo htmlspecialchars($nodarbiba['trenera_vards'] . ' ' . $nodarbiba['trenera_uzvards']); ?><br>
                                            <strong>Laiks:</strong> <?php echo date('d.m.Y H:i', strtotime($nodarbiba['sakuma_laiks'])); ?>
                                        </p>
                                        <a href="nodarbibas.php" class="btn btn-primary btn-sm">Skatīt vairāk</a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Ātrās darbības -->
        <div class="row mt-4">
            <div class="col-12">
                <h3>Ātrās darbības</h3>
                <div class="row mt-3">
                    <div class="col-md-3 mb-2">
                        <a href="nodarbibas.php" class="btn btn-outline-primary w-100">Pieteikties nodarbībai</a>
                    </div>
                    <div class="col-md-3 mb-2">
                        <a href="nodarbibu_vesture.php" class="btn btn-outline-info w-100">Nodarbību vēsture</a>
                    </div>
                    <div class="col-md-3 mb-2">
                        <a href="zinojumi.php" class="btn btn-outline-success w-100">Ziņojumi</a>
                    </div>
                    <div class="col-md-3 mb-2">
                        <a href="../dashboard.php" class="btn btn-outline-secondary w-100">Dashboard</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>