<?php
// Ziņojumu sistēma
class Zinojumi {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    // Nosūtīt ziņojumu
    public function nosutitZinojumu($no_id, $kam_id, $teksts) {
        $sql = "INSERT INTO zinojumi (no_lietotaja_id, kam_lietotaja_id, teksts, nosutits) VALUES (?, ?, ?, NOW())";
        $this->db->izpilditVaicajumu($sql, [$no_id, $kam_id, $teksts]);
        return $this->db->iegutPedejoId();
    }
    
    // Iegūt sarunas starp diviem lietotājiem
    public function iegutSarunu($lietotaja1_id, $lietotaja2_id) {
        $sql = "SELECT z.*, 
                       no.vards AS no_vards, no.uzvards AS no_uzvards,
                       kam.vards AS kam_vards, kam.uzvards AS kam_uzvards
                FROM zinojumi z
                LEFT JOIN lietotaji no ON z.no_lietotaja_id = no.id
                LEFT JOIN lietotaji kam ON z.kam_lietotaja_id = kam.id
                WHERE (z.no_lietotaja_id = ? AND z.kam_lietotaja_id = ?)
                   OR (z.no_lietotaja_id = ? AND z.kam_lietotaja_id = ?)
                ORDER BY z.nosutits ASC";
        return $this->db->izpilditVaicajumu($sql, [$lietotaja1_id, $lietotaja2_id, $lietotaja2_id, $lietotaja1_id])->fetchAll();
    }
    
    // Iegūt visas sarunas lietotājam
    public function iegutSarunas($lietotaja_id) {
        $sql = "SELECT DISTINCT 
                    CASE 
                        WHEN z.no_lietotaja_id = ? THEN z.kam_lietotaja_id 
                        ELSE z.no_lietotaja_id 
                    END AS otra_lietotaja_id,
                    l.vards, l.uzvards, l.loma,
                    (SELECT teksts FROM zinojumi z2 
                     WHERE (z2.no_lietotaja_id = ? AND z2.kam_lietotaja_id = l.id)
                        OR (z2.no_lietotaja_id = l.id AND z2.kam_lietotaja_id = ?)
                     ORDER BY z2.nosutits DESC LIMIT 1) AS pedejais_zinojums,
                    (SELECT nosutits FROM zinojumi z3 
                     WHERE (z3.no_lietotaja_id = ? AND z3.kam_lietotaja_id = l.id)
                        OR (z3.no_lietotaja_id = l.id AND z3.kam_lietotaja_id = ?)
                     ORDER BY z3.nosutits DESC LIMIT 1) AS pedejais_laiks,
                    (SELECT COUNT(*) FROM zinojumi z4 
                     WHERE z4.no_lietotaja_id = l.id AND z4.kam_lietotaja_id = ? AND z4.izlasits = 0) AS neizlasiti
                FROM zinojumi z
                LEFT JOIN lietotaji l ON (
                    CASE 
                        WHEN z.no_lietotaja_id = ? THEN z.kam_lietotaja_id 
                        ELSE z.no_lietotaja_id 
                    END = l.id
                )
                WHERE z.no_lietotaja_id = ? OR z.kam_lietotaja_id = ?
                ORDER BY pedejais_laiks DESC";
        return $this->db->izpilditVaicajumu($sql, [
            $lietotaja_id, $lietotaja_id, $lietotaja_id, 
            $lietotaja_id, $lietotaja_id, $lietotaja_id,
            $lietotaja_id, $lietotaja_id, $lietotaja_id
        ])->fetchAll();
    }
    
    // Atzīmēt ziņojumus kā izlasītus
    public function atzimetKaIzlasitus($no_id, $kam_id) {
        $sql = "UPDATE zinojumi SET izlasits = 1 WHERE no_lietotaja_id = ? AND kam_lietotaja_id = ?";
        $this->db->izpilditVaicajumu($sql, [$no_id, $kam_id]);
    }
    
    // Iegūt neizlasīto ziņojumu skaitu
    public function iegutNeizlasituSkaitu($lietotaja_id) {
        $sql = "SELECT COUNT(*) as skaits FROM zinojumi WHERE kam_lietotaja_id = ? AND izlasits = 0";
        return $this->db->izpilditVaicajumu($sql, [$lietotaja_id])->fetch()['skaits'];
    }
}
?>
