<?php
// Vienots galvenes komponents visām lapām
if (!isset($auth)) {
    require_once __DIR__ . '/config.php';
    $auth = new Auth();
}

$current_user = $auth->getCurrentUser();
$current_page = basename($_SERVER['PHP_SELF']);
$current_dir = basename(dirname($_SERVER['PHP_SELF']));

// Noteikt aktīvo sadaļu
$is_admin = $current_dir === 'admin';
$is_trainer = $current_dir === 'treneris';
$is_client = $current_dir === 'klients';

// Noteikt krāsu shēmu
if ($is_admin) {
    $navbar_class = 'navbar-admin';
    $brand_text = '💪 Sporta Zāle - Admin';
} elseif ($is_trainer) {
    $navbar_class = 'navbar-trainer';
    $brand_text = '💪 Sporta Zāle - Treneris';
} elseif ($is_client) {
    $navbar_class = 'navbar-client';
    $brand_text = '💪 Sporta Zāle - Klients';
} else {
    $navbar_class = 'navbar-main';
    $brand_text = '💪 Sporta Zāle';
}

// Iegūt neizlasīto ziņojumu skaitu
$neizlasiti_zinojumi = 0;
if ($current_user && file_exists(__DIR__ . '/zinojumi.php')) {
    require_once __DIR__ . '/zinojumi.php';
    try {
        $zinojumi_obj = new Zinojumi();
        $neizlasiti_zinojumi = $zinojumi_obj->iegutNeizlasituSkaitu($current_user['id']);
    } catch (Exception $e) {
        // Tabula vēl nav izveidota - ignorēt kļūdu
        $neizlasiti_zinojumi = 0;
    }
}
?>
<nav class="navbar navbar-expand-lg <?php echo $navbar_class; ?>">
    <div class="container">
        <a class="navbar-brand" href="#"><?php echo $brand_text; ?></a>
        
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        
        <div class="collapse navbar-collapse" id="navbarNav">
            <?php if ($current_user): ?>
                <ul class="navbar-nav me-auto">
                    <?php if ($is_admin): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'index.php' ? 'active' : ''; ?>" href="index.php">Panelis</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'lietotaji.php' ? 'active' : ''; ?>" href="lietotaji.php">Lietotāji</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'nodarbibas.php' ? 'active' : ''; ?>" href="nodarbibas.php">Nodarbības</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'darbibas.php' ? 'active' : ''; ?>" href="darbibas.php">Darbības</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'inventars.php' ? 'active' : ''; ?>" href="inventars.php">Inventārs</a>
                        </li>
                    <?php elseif ($is_trainer): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'index.php' ? 'active' : ''; ?>" href="index.php">Panelis</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'mans_grafiks.php' ? 'active' : ''; ?>" href="mans_grafiks.php">Mans grafiks</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'mani_klienti.php' ? 'active' : ''; ?>" href="mani_klienti.php">Mani klienti</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'zinojumi.php' ? 'active' : ''; ?>" href="zinojumi.php">
                                Ziņojumi
                                <?php if ($neizlasiti_zinojumi > 0): ?>
                                    <span class="badge bg-danger"><?php echo $neizlasiti_zinojumi; ?></span>
                                <?php endif; ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'inventars.php' ? 'active' : ''; ?>" href="inventars.php">Inventārs</a>
                        </li>
                    <?php elseif ($is_client): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'index.php' ? 'active' : ''; ?>" href="index.php">Panelis</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'nodarbibas.php' ? 'active' : ''; ?>" href="nodarbibas.php">Nodarbības</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'nodarbibu_vesture.php' ? 'active' : ''; ?>" href="nodarbibu_vesture.php">Vēsture</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'zinojumi.php' ? 'active' : ''; ?>" href="zinojumi.php">
                                Ziņojumi
                                <?php if ($neizlasiti_zinojumi > 0): ?>
                                    <span class="badge bg-danger"><?php echo $neizlasiti_zinojumi; ?></span>
                                <?php endif; ?>
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
                
                <ul class="navbar-nav">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown">
                            <span class="user-avatar me-2"><?php echo strtoupper(substr($current_user['vards'], 0, 1)); ?></span>
                            <?php echo htmlspecialchars($current_user['vards']); ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><span class="dropdown-item-text text-muted"><?php echo htmlspecialchars($current_user['epasts']); ?></span></li>
                            <li><hr class="dropdown-divider"></li>
                            <?php 
                            $base_path = $is_admin || $is_trainer || $is_client ? '../' : '';
                            ?>
                            <li><a class="dropdown-item" href="<?php echo $base_path; ?>dashboard.php">Dashboard</a></li>
                            <?php if ($current_user['loma'] === 'administrators'): ?>
                                <li><a class="dropdown-item" href="<?php echo $base_path; ?>admin/index.php">Admin Panelis</a></li>
                            <?php endif; ?>
                            <?php if ($current_user['loma'] === 'administrators' || $current_user['loma'] === 'treneris'): ?>
                                <li><a class="dropdown-item" href="<?php echo $base_path; ?>treneris/index.php">Trenera Panelis</a></li>
                            <?php endif; ?>
                            <li><a class="dropdown-item" href="<?php echo $base_path; ?>klients/index.php">Klienta Panelis</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="<?php echo $base_path; ?>klients/profils.php">Profils</a></li>
                            <li><a class="dropdown-item text-danger" href="<?php echo $base_path; ?>includes/izlogoties.php">Izlogoties</a></li>
                        </ul>
                    </li>
                </ul>
            <?php endif; ?>
        </div>
    </div>
</nav>
