<?php
// Pārbauda, vai Database klase jau ir ielādēta
if (!class_exists('Database')) {
    require_once 'Database.php';
}

class Email {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function sutitParolesAtjaunosanasEmail($epasts, $token) {
        $atjaunosanasLinks = SITE_URL . "jauna_parole.php?token=" . $token;
        
        $virsraksts = "Paroles atjaunošana - Sporta Zāle";
        $saturs = "
        <html>
        <head>
            <style>
                body { font-family: Arial, sans-serif; margin: 0; padding: 20px; background: #f5f5f5; }
                .container { max-width: 600px; margin: 0 auto; background: white; border-radius: 10px; overflow: hidden; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
                .header { background: linear-gradient(135deg, #667eea, #764ba2); color: white; padding: 30px; text-align: center; }
                .content { padding: 30px; }
                .button { background: #667eea; color: white; padding: 12px 24px; text-decoration: none; border-radius: 5px; display: inline-block; margin: 15px 0; }
                .footer { background: #f8f9fa; padding: 20px; text-align: center; color: #6c757d; font-size: 14px; }
                .token-info { background: #f8f9fa; padding: 15px; border-radius: 5px; margin: 15px 0; font-family: monospace; }
            </style>
        </head>
        <body>
            <div class='container'>
                <div class='header'>
                    <h1>💪 Sporta Zāle</h1>
                    <h2>Paroles atjaunošana</h2>
                </div>
                <div class='content'>
                    <p>Sveiki!</p>
                    <p>Jūs esat pieprasījis paroles atjaunošanu. Lai atjaunotu paroli, lūdzu, noklikšķiniet uz zemāk redzamās saites:</p>
                    <p style='text-align: center;'>
                        <a href='{$atjaunosanasLinks}' class='button'>Atjaunot Paroli</a>
                    </p>
                    
                    <div class='token-info'>
                        <strong>TESTA REŽĪMS:</strong><br>
                        Ja saite nestrādā, kopējiet šo linku:<br>
                        <a href='{$atjaunosanasLinks}'>{$atjaunosanasLinks}</a>
                    </div>
                    
                    <p><strong>Saite ir derīga 1 stundu.</strong></p>
                    <p>Ja jūs neesat pieprasījis paroles atjaunošanu, lūdzu, ignorējiet šo e-pastu.</p>
                </div>
                <div class='footer'>
                    <p>Ar cieņu,<br><strong>Sporta Zāles komanda</strong></p>
                    <p>Šis ir automātisks e-pasts, lūduz neatbildiet uz to.</p>
                </div>
            </div>
        </body>
        </html>
        ";
        
        // TESTA REŽĪMS - vienmēr atgriež true un saglabā token failā
        return $this->sutitEmailTestaRezimā($epasts, $virsraksts, $saturs, $token);
    }
    
    private function sutitEmailTestaRezimā($epasts, $virsraksts, $saturs, $token) {
        // 1. Saglabā token failā testēšanai
        $testaFails = __DIR__ . '/../testa_tokeni.txt';
        $ieraksts = date('Y-m-d H:i:s') . " | Epasts: $epasts | Token: $token\n";
        file_put_contents($testaFails, $ieraksts, FILE_APPEND | LOCK_EX);
        
        // 2. Parāda token ekrānā (tikai izstrādes režīmā)
        if (isset($_SESSION['lietotaja_id']) && $_SESSION['loma'] == 'administrators') {
            $_SESSION['testa_token'] = $token;
        }
        
        // 3. Vienmēr atgriež true, lai sistēma turpinātu darboties
        return true;
    }
    
    public function izveidotParolesToken($lietotaja_id) {
        $token = bin2hex(random_bytes(32));
        $derigs_lidz = date('Y-m-d H:i:s', strtotime('+1 hour'));
        
        // Dzēš vecos tokenus
        $this->db->izpilditVaicajumu(
            "DELETE FROM atjauninas_token WHERE lietotaja_id = ? OR derigs_lidz < NOW()",
            [$lietotaja_id]
        );
        
        // Izveido jaunu token
        $sql = "INSERT INTO atjauninas_token (lietotaja_id, token, derigs_lidz) VALUES (?, ?, ?)";
        $this->db->izpilditVaicajumu($sql, [$lietotaja_id, $token, $derigs_lidz]);
        
        return $token;
    }
    
    public function parbauditToken($token) {
        // PĀRBAUDE AR DEBUG
        error_log("Pārbauda token: " . $token);
        
        $sql = "SELECT * FROM atjauninas_token WHERE token = ? AND derigs_lidz > NOW() AND izmantots = FALSE";
        $atsauce = $this->db->izpilditVaicajumu($sql, [$token]);
        $result = $atsauce->fetch();
        
        error_log("Token pārbaudes rezultāts: " . ($result ? "ATRASTS" : "NAV ATRASTS"));
        
        return $result;
    }
    
    public function atzimetTokenKaIzmantotu($token_id) {
        $sql = "UPDATE atjauninas_token SET izmantots = TRUE WHERE id = ?";
        $this->db->izpilditVaicajumu($sql, [$token_id]);
    }
    
    // Atrod lietotāju pēc e-pasta
    public function atrastLietotajuPecEpasta($epasts) {
        $sql = "SELECT id FROM lietotaji WHERE epasts = ?";
        $atsauce = $this->db->izpilditVaicajumu($sql, [$epasts]);
        $lietotajs = $atsauce->fetch();
        return $lietotajs ? $lietotajs['id'] : null;
    }
    
    // Testa metode token iegūšanai
    public function iegutPedejoTestaToken() {
        $testaFails = __DIR__ . '/../testa_tokeni.txt';
        if (file_exists($testaFails)) {
            $saturs = file($testaFails);
            if (!empty($saturs)) {
                $pedejais = end($saturs);
                if (preg_match('/Token: ([a-f0-9]+)/', $pedejais, $matches)) {
                    return $matches[1];
                }
            }
        }
        return null;
    }
    
    // TESTA METODE - izveido testa token datu bāzē
    public function izveidotTestaToken() {
        $testa_lietotaja_id = 1; // admin lietotājs
        $token = "test123"; // Vienkāršs tests token
        
        // Dzēš vecos tokenus
        $this->db->izpilditVaicajumu(
            "DELETE FROM atjauninas_token WHERE lietotaja_id = ?",
            [$testa_lietotaja_id]
        );
        
        // Izveido testa token
        $derigs_lidz = date('Y-m-d H:i:s', strtotime('+1 hour'));
        $sql = "INSERT INTO atjauninas_token (lietotaja_id, token, derigs_lidz) VALUES (?, ?, ?)";
        $this->db->izpilditVaicajumu($sql, [$testa_lietotaja_id, $token, $derigs_lidz]);
        
        return $token;
    }
}
?>