<?php
class Database {
    private $savienojums;
    private static $instance = null;
    
    public function __construct() {
        try {
            $this->savienojums = new PDO(
                "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
                DB_USER, 
                DB_PASS,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
            // Iestatīt laika zonu
            $this->savienojums->exec("SET time_zone = '+02:00'");
        } catch(PDOException $e) {
            // Labāka kļūdu apstrāde
            error_log("Datu bāzes kļūda: " . $e->getMessage());
            die("Kļūda savienojoties ar datu bāzi. Lūdzu, mēģiniet vēlāk.");
        }
    }
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    public function iegutSavienojumu() {
        return $this->savienojums;
    }
    
    public function izpilditVaicajumu($sql, $parametri = []) {
        try {
            $atsauce = $this->savienojums->prepare($sql);
            $atsauce->execute($parametri);
            return $atsauce;
        } catch(PDOException $e) {
            error_log("SQL kļūda: " . $e->getMessage() . " Query: " . $sql);
            throw new Exception("Datu bāzes kļūda");
        }
    }
    
    public function iegutPedejoId() {
        return $this->savienojums->lastInsertId();
    }
}
?>