<?php
if (!class_exists('Database')) {
    require_once 'Database.php';
}

class Auth {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function pieslegties($epasts, $parole) {
        $sql = "SELECT * FROM lietotaji WHERE epasts = ? AND aktivizets = 1";
        $atsauce = $this->db->izpilditVaicajumu($sql, [$epasts]);
        $lietotajs = $atsauce->fetch();
        
        if ($lietotajs && password_verify($parole, $lietotajs['parole'])) {
            $_SESSION['lietotaja_id'] = $lietotajs['id'];
            $_SESSION['vards'] = $lietotajs['vards'];
            $_SESSION['uzvards'] = $lietotajs['uzvards'];
            $_SESSION['epasts'] = $lietotajs['epasts'];
            $_SESSION['loma'] = $lietotajs['loma'];
            
            // ATJAUNINA PIERAKSTĪŠANĀS SKAITĪTĀJU UN DATUMU
            $this->atjauninatPierakstisanasDatus($lietotajs['id']);
            
            return true;
        }
        
        return false;
    }
    
    private function atjauninatPierakstisanasDatus($lietotaja_id) {
        // Palielina skaitītāju par 1 un iestata pašreizējo datumu/laiku
        $sql = "UPDATE lietotaji SET 
                pierakstisanas_skaititajs = pierakstisanas_skaititajs + 1, 
                pedeja_pierakstisanas = NOW() 
                WHERE id = ?";
        $this->db->izpilditVaicajumu($sql, [$lietotaja_id]);
    }
    
    public function izlogoties() {
        session_destroy();
        header("Location: ../index.php");
        exit();
    }
    
    public function isLoggedIn() {
        return isset($_SESSION['lietotaja_id']);
    }
    
    public function getCurrentUser() {
        if ($this->isLoggedIn()) {
            $sql = "SELECT * FROM lietotaji WHERE id = ?";
            $result = $this->db->izpilditVaicajumu($sql, [$_SESSION['lietotaja_id']]);
            return $result->fetch();
        }
        return null;
    }
    
    // Pārbaudīt vai lietotājam jāaizpilda profils
    public function needsProfileCompletion() {
        if (!$this->isLoggedIn()) return false;
        $lietotajs = $this->getCurrentUser();
        return empty($lietotajs['telefons']) || empty($lietotajs['dzimsanas_datums']);
    }
    
    public function hasRole($loma) {
        return $this->isLoggedIn() && $_SESSION['loma'] === $loma;
    }
    
    // Papildus metode skaitītāja iegūšanai
    public function iegutPierakstisanasSkaitu($lietotaja_id) {
        $sql = "SELECT pierakstisanas_skaititajs FROM lietotaji WHERE id = ?";
        $result = $this->db->izpilditVaicajumu($sql, [$lietotaja_id]);
        $data = $result->fetch();
        return $data['pierakstisanas_skaititajs'] ?? 0;
    }
    
    // Iegūt redirektēšanas URL atbilstoši lietotāja lomai
    public function getRedirectUrl() {
        if (!$this->isLoggedIn()) return 'index.php';
        
        $lietotajs = $this->getCurrentUser();
        $loma = $lietotajs['loma'] ?? '';
        
        switch ($loma) {
            case 'administrators':
                return 'admin/index.php';
            case 'treneris':
                return 'treneris/index.php';
            case 'klients':
            default:
                return 'klients/index.php';
        }
    }
}
?>