<?php
require_once 'includes/config.php';

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    header("Location: index.php");
    exit();
}

$lietotajs = $auth->getCurrentUser();
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panelis - Sporta Zāle</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <div class="container mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h2>Labdien, <?php echo htmlspecialchars($lietotajs['vards']); ?>!</h2>
                    </div>
                    <div class="card-body">
                        <p><strong>E-pasts:</strong> <?php echo htmlspecialchars($lietotajs['epasts']); ?></p>
                        <p><strong>Loma:</strong> 
                            <span class="badge 
                                <?php 
                                if ($lietotajs['loma'] === 'administrators') echo 'bg-primary';
                                elseif ($lietotajs['loma'] === 'treneris') echo 'bg-success';
                                else echo 'bg-info';
                                ?>">
                                <?php echo htmlspecialchars($lietotajs['loma']); ?>
                            </span>
                        </p>
                        
                        <hr>
                        
                        <div class="mt-4">
                            <h4>Ātrās darbības:</h4>
                            <div class="row mt-3">
                                <?php if ($lietotajs['loma'] === 'administrators'): ?>
                                    <div class="col-md-4 mb-3">
                                        <a href="admin/index.php" class="btn btn-primary btn-lg w-100 py-3">
                                            <div class="mb-2">🔧</div>
                                            Admin Panelis
                                        </a>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <a href="treneris/index.php" class="btn btn-success btn-lg w-100 py-3">
                                            <div class="mb-2">🏋️</div>
                                            Trenera Panelis
                                        </a>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <a href="klients/index.php" class="btn btn-info btn-lg w-100 py-3">
                                            <div class="mb-2">👤</div>
                                            Klienta Panelis
                                        </a>
                                    </div>
                                <?php elseif ($lietotajs['loma'] === 'treneris'): ?>
                                    <div class="col-md-6 mb-3">
                                        <a href="treneris/index.php" class="btn btn-success btn-lg w-100 py-3">
                                            <div class="mb-2">🏋️</div>
                                            Trenera Panelis
                                        </a>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <a href="klients/index.php" class="btn btn-info btn-lg w-100 py-3">
                                            <div class="mb-2">👤</div>
                                            Klienta Panelis
                                        </a>
                                    </div>
                                <?php else: ?>
                                    <div class="col-md-12 mb-3">
                                        <a href="klients/index.php" class="btn btn-info btn-lg w-100 py-3">
                                            <div class="mb-2">👤</div>
                                            Klienta Panelis
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
