// Galvenās JavaScript funkcijas visai lapai

class SportaZaleApp {
    constructor() {
        this.init();
    }
    
    init() {
        this.setupEventListeners();
        this.handleResponsive();
        this.setupAjax();
    }
    
    setupEventListeners() {
        // Global error handling
        window.addEventListener('error', this.handleGlobalError.bind(this));
        
        // Form validation
        document.addEventListener('submit', this.handleFormSubmit.bind(this));
        
        // Loading states
        document.addEventListener('click', this.handleLoadingStates.bind(this));
    }
    
    handleGlobalError(event) {
        console.error('Global error:', event.error);
        // Varētu nosūtīt uz kļūdu logging servisu
    }
    
    handleFormSubmit(e) {
        const form = e.target;
        const submitBtn = form.querySelector('button[type="submit"]');
        
        if (submitBtn) {
            // Add loading state
            submitBtn.disabled = true;
            submitBtn.innerHTML = '⏳ Ielādē...';
            
            // Auto re-enable after 10 seconds in case of error
            setTimeout(() => {
                if (submitBtn.disabled) {
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = 'Iesniegt';
                }
            }, 10000);
        }
    }
    
    handleLoadingStates(e) {
        const target = e.target;
        
        if (target.classList.contains('btn') && !target.disabled) {
            // Add temporary loading feedback
            const originalText = target.innerHTML;
            target.innerHTML = '⏳';
            
            setTimeout(() => {
                target.innerHTML = originalText;
            }, 1000);
        }
    }
    
    handleResponsive() {
        // Dynamic viewport height for mobile
        this.setViewportHeight();
        window.addEventListener('resize', this.setViewportHeight.bind(this));
    }
    
    setViewportHeight() {
        const vh = window.innerHeight * 0.01;
        document.documentElement.style.setProperty('--vh', `${vh}px`);
    }
    
    setupAjax() {
        // Global AJAX setup
        $.ajaxSetup({
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', error);
                alert('Radās kļūda. Lūdzu, mēģiniet vēlreiz.');
            }
        });
    }
    
    // Utility functions
    static showNotification(message, type = 'info') {
        const notification = document.createElement('div');
        notification.className = `alert alert-${type} alert-dismissible fade show`;
        notification.innerHTML = `
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        `;
        
        document.body.insertBefore(notification, document.body.firstChild);
        
        setTimeout(() => {
            if (notification.parentNode) {
                notification.remove();
            }
        }, 5000);
    }
    
    static formatDate(dateString) {
        const options = { 
            year: 'numeric', 
            month: '2-digit', 
            day: '2-digit',
            hour: '2-digit',
            minute: '2-digit'
        };
        return new Date(dateString).toLocaleDateString('lv-LV', options);
    }
}

// Initialize app when DOM is ready
document.addEventListener('DOMContentLoaded', function() {
    window.sportaZaleApp = new SportaZaleApp();
});