<?php
// Sistēmas iestatīšanas skripts

session_start();
require_once '../includes/config.php';

// Pārbauda, vai datu bāze jau eksistē
try {
    $db = Database::getInstance();
    $db->izpilditVaicajumu("SELECT 1 FROM lietotaji LIMIT 1");
    
    // Ja datu bāze jau ir iestatīta, novirza uz index
    header("Location: ../index.php");
    exit();
} catch (Exception $e) {
    // Datu bāze vēl nav iestatīta, turpina ar iestatīšanu
}

$kļūda = '';
$veiksme = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $admin_epasts = trim($_POST['admin_epasts']);
    $admin_parole = $_POST['admin_parole'];
    
    if (empty($admin_epasts) || empty($admin_parole)) {
        $kļūda = "Lūdzu, aizpildiet visus laukus!";
    } else {
        // Izpilda datu bāzes iestatīšanu
        $sql_file = file_get_contents('database.sql');
        $sql_queries = explode(';', $sql_file);
        
        try {
            $db = Database::getInstance();
            
            foreach ($sql_queries as $query) {
                $query = trim($query);
                if (!empty($query)) {
                    $db->izpilditVaicajumu($query);
                }
            }
            
            // Atjaunina administratora e-pastu un paroli
            $hashed_parole = password_hash($admin_parole, PASSWORD_DEFAULT);
            $db->izpilditVaicajumu(
                "UPDATE lietotaji SET epasts = ?, parole = ? WHERE loma = 'administrators'",
                [$admin_epasts, $hashed_parole]
            );
            
            $veiksme = "Sistēma veiksmīgi iestatīta! Varat pieslēgties.";
            
        } catch (Exception $e) {
            $kļūda = "Kļūda iestatot sistēmu: " . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistēmas Iestatīšana - Sporta Zāle</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body class="login-body">
    <div class="container-fluid h-100">
        <div class="row h-100 justify-content-center align-items-center">
            <div class="col-12 col-md-6 col-lg-4">
                <div class="login-card">
                    <div class="text-center mb-4">
                        <div class="logo-container">
                            <span class="logo-icon">⚙️</span>
                            <h1 class="h3 fw-bold">Sistēmas Iestatīšana</h1>
                        </div>
                        <p class="text-muted">Iestatiet administratora kontu</p>
                    </div>

                    <?php if ($kļūda): ?>
                        <div class="alert alert-danger"><?php echo $kļūda; ?></div>
                    <?php endif; ?>
                    
                    <?php if ($veiksme): ?>
                        <div class="alert alert-success">
                            <?php echo $veiksme; ?>
                            <div class="mt-3">
                                <a href="../index.php" class="btn btn-success">Pieslēgties</a>
                            </div>
                        </div>
                    <?php else: ?>
                        <form method="POST" action="">
                            <div class="mb-3">
                                <label for="admin_epasts" class="form-label">Administratora E-pasts</label>
                                <input type="email" class="form-control" id="admin_epasts" name="admin_epasts" required>
                            </div>
                            
                            <div class="mb-3">
                                <label for="admin_parole" class="form-label">Administratora Parole</label>
                                <input type="password" class="form-control" id="admin_parole" name="admin_parole" required>
                            </div>

                            <button type="submit" class="btn btn-primary btn-lg w-100 mb-3">
                                Iestatīt Sistēmu
                            </button>
                        </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>