-- --------------------------------------------------------
-- Nodarbību inventāra saistību tabula
-- Šī tabula saista nodarbības ar nepieciešamo inventāru
-- --------------------------------------------------------

-- Dumping structure for table sporta_zale.nodarbibas_inventars
DROP TABLE IF EXISTS `nodarbibas_inventars`;
CREATE TABLE IF NOT EXISTS `nodarbibas_inventars` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unikāls ieraksta ID',
  `nodarbibas_id` int(11) NOT NULL COMMENT 'Atsauce uz nodarbību (nodarbibas.id)',
  `inventara_id` int(11) NOT NULL COMMENT 'Atsauce uz inventāru (inventars.id)',
  `daudzums` int(11) DEFAULT 1 COMMENT 'Nepieciešamais daudzums',
  PRIMARY KEY (`id`),
  KEY `idx_nodarbibas_id` (`nodarbibas_id`),
  KEY `idx_inventara_id` (`inventara_id`),
  CONSTRAINT `nodarbibas_inventars_ibfk_1` FOREIGN KEY (`nodarbibas_id`) REFERENCES `nodarbibas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `nodarbibas_inventars_ibfk_2` FOREIGN KEY (`inventara_id`) REFERENCES `inventars` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Nodarbību un inventāra saistību tabula';
