<?php
session_start();
require_once '../includes/config.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasRole('administrators')) {
    header("Location: ../index.php");
    exit();
}

$lietotajs = $auth->getCurrentUser();
$db = Database::getInstance();

// Apstrādāt formas iesniegšanu
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $vards = trim($_POST['vards'] ?? '');
    $uzvards = trim($_POST['uzvards'] ?? '');
    $telefons = trim($_POST['telefons'] ?? '');
    $dzimsanas_datums = $_POST['dzimsanas_datums'] ?? '';
    
    $errors = [];
    
    if (empty($vards)) {
        $errors[] = "Vārds ir obligāts lauks.";
    }
    if (empty($uzvards)) {
        $errors[] = "Uzvārds ir obligāts lauks.";
    }
    
    if (empty($errors)) {
        $sql = "UPDATE lietotaji SET vards = ?, uzvards = ?, telefons = ?, dzimsanas_datums = ? WHERE id = ?";
        $db->izpilditVaicajumu($sql, [$vards, $uzvards, $telefons, $dzimsanas_datums, $lietotajs['id']]);
        
        $atjaunotais = $db->izpilditVaicajumu("SELECT * FROM lietotaji WHERE id = ?", [$lietotajs['id']])->fetch();
        $_SESSION['lietotajs'] = $atjaunotais;
        
        $db->izpilditVaicajumu(
            "INSERT INTO zurnals (lietotaja_id, darbiba, ip_adrese) VALUES (?, ?, ?)",
            [$lietotajs['id'], 'Atjaunoja profilu', $_SERVER['REMOTE_ADDR'] ?? '']
        );
        
        $_SESSION['veiksme'] = "Profils veiksmīgi atjaunots!";
        header("Location: index.php");
        exit();
    }
}
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profils - Admin Panelis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <?php include '../includes/header.php'; ?>

    <div class="container mt-4">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header bg-danger text-white">
                        <h4 class="mb-0">Mans profils</h4>
                    </div>
                    <div class="card-body">
                        <?php if (isset($errors) && !empty($errors)): ?>
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    <?php foreach ($errors as $error): ?>
                                        <li><?php echo $error; ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (isset($_SESSION['veiksme'])): ?>
                            <div class="alert alert-success"><?php echo $_SESSION['veiksme']; unset($_SESSION['veiksme']); ?></div>
                        <?php endif; ?>
                        
                        <form method="POST">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="vards" class="form-label">Vārds *</label>
                                    <input type="text" class="form-control" id="vards" name="vards" 
                                           value="<?php echo htmlspecialchars($lietotajs['vards'] ?? ''); ?>" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="uzvards" class="form-label">Uzvārds *</label>
                                    <input type="text" class="form-control" id="uzvards" name="uzvards" 
                                           value="<?php echo htmlspecialchars($lietotajs['uzvards'] ?? ''); ?>" required>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label for="epasts" class="form-label">E-pasts</label>
                                <input type="email" class="form-control" id="epasts" 
                                       value="<?php echo htmlspecialchars($lietotajs['epasts'] ?? ''); ?>" disabled>
                            </div>
                            
                            <div class="mb-3">
                                <label for="telefons" class="form-label">Telefona numurs</label>
                                <input type="tel" class="form-control" id="telefons" name="telefons" 
                                       value="<?php echo htmlspecialchars($lietotajs['telefons'] ?? ''); ?>">
                            </div>
                            
                            <div class="mb-3">
                                <label for="dzimsanas_datums" class="form-label">Dzimšanas datums</label>
                                <input type="date" class="form-control" id="dzimsanas_datums" name="dzimsanas_datums" 
                                       value="<?php echo htmlspecialchars($lietotajs['dzimsanas_datums'] ?? ''); ?>">
                            </div>
                            
                            <div class="d-flex justify-content-between">
                                <a href="index.php" class="btn btn-secondary">Atpakaļ</a>
                                <button type="submit" class="btn btn-danger">Saglabāt</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
