<?php
session_start();
require_once '../includes/config.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasRole('administrators')) {
    header("Location: ../index.php");
    exit();
}

$db = Database::getInstance();
$kļūda = '';
$veiksme = '';

// Apstrādā formas iesniegšanu
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $vards = trim($_POST['vards']);
    $uzvards = trim($_POST['uzvards']);
    $epasts = trim($_POST['epasts']);
    $parole = $_POST['parole'];
    $telefons = trim($_POST['telefons']);
    $loma = $_POST['loma'];
    
    // Validācija
    if (empty($vards) || empty($uzvards) || empty($epasts) || empty($parole)) {
        $kļūda = "Lūdzu, aizpildiet visus obligātos laukus!";
    } elseif (!filter_var($epasts, FILTER_VALIDATE_EMAIL)) {
        $kļūda = "Lūdzu, ievadiet derīgu e-pasta adresi!";
    } elseif (strlen($parole) < 6) {
        $kļūda = "Parolei jābūt vismaz 6 simbolus garai!";
    } else {
        $user = new User();
        if ($user->registretLietotaju($vards, $uzvards, $epasts, $parole, $loma)) {
            // Ja nepieciešams, atjaunina papildus datus
            if (!empty($telefons)) {
                $jaunais_id = $db->iegutPedejoId();
                $db->izpilditVaicajumu(
                    "UPDATE lietotaji SET telefons = ? WHERE id = ?",
                    [$telefons, $jaunais_id]
                );
            }
            
            $_SESSION['veiksme'] = "Lietotājs veiksmīgi pievienots!";
            header("Location: lietotaji.php");
            exit();
        } else {
            $kļūda = "E-pasts jau ir reģistrēts!";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pievienot Lietotāju - Admin Panelis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="#">💪 Sporta Zāle - Admin</a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="index.php">Panelis</a>
                <a class="nav-link" href="lietotaji.php">Lietotāji</a>
                <a class="nav-link" href="../dashboard.php">Dashboard</a>
                <a class="nav-link" href="../includes/izlogoties.php">Izlogoties</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1>Pievienot Jaunu Lietotāju</h1>
            <a href="lietotaji.php" class="btn btn-secondary">Atpakaļ</a>
        </div>

        <?php if ($kļūda): ?>
            <div class="alert alert-danger"><?php echo $kļūda; ?></div>
        <?php endif; ?>

        <div class="card">
            <div class="card-body">
                <form method="POST" action="">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="vards" class="form-label">Vārds *</label>
                            <input type="text" class="form-control" id="vards" name="vards" 
                                   value="<?php echo isset($_POST['vards']) ? htmlspecialchars($_POST['vards']) : ''; ?>" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="uzvards" class="form-label">Uzvārds *</label>
                            <input type="text" class="form-control" id="uzvards" name="uzvards"
                                   value="<?php echo isset($_POST['uzvards']) ? htmlspecialchars($_POST['uzvards']) : ''; ?>" required>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="epasts" class="form-label">E-pasts *</label>
                        <input type="email" class="form-control" id="epasts" name="epasts"
                               value="<?php echo isset($_POST['epasts']) ? htmlspecialchars($_POST['epasts']) : ''; ?>" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="parole" class="form-label">Parole *</label>
                        <input type="password" class="form-control" id="parole" name="parole" required>
                        <div class="form-text">Parolei jābūt vismaz 6 simbolus garai.</div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="telefons" class="form-label">Telefons</label>
                        <input type="tel" class="form-control" id="telefons" name="telefons"
                               value="<?php echo isset($_POST['telefons']) ? htmlspecialchars($_POST['telefons']) : ''; ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label for="loma" class="form-label">Loma *</label>
                        <select class="form-control" id="loma" name="loma" required>
                            <option value="klients">Klients</option>
                            <option value="treneris">Treneris</option>
                            <option value="administrators">Administrators</option>
                        </select>
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <a href="lietotaji.php" class="btn btn-secondary me-md-2">Atcelt</a>
                        <button type="submit" class="btn btn-primary">Pievienot Lietotāju</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>