<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/database.php';
require_once '../includes/auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasRole('administrators')) {
    header("Location: ../index.php");
    exit();
}

$lietotajs = $auth->getCurrentUser();
$db = Database::getInstance();

// Filtri
$lietotaja_id = isset($_GET['lietotajs']) ? intval($_GET['lietotajs']) : 0;
$darbiba = isset($_GET['darbiba']) ? $_GET['darbiba'] : '';
$datums_no = isset($_GET['datums_no']) ? $_GET['datums_no'] : '';
$datums_lidz = isset($_GET['datums_lidz']) ? $_GET['datums_lidz'] : '';

// SQL vaicājums ar filtriem
$sql = "SELECT z.*, l.vards, l.uzvards, l.epasts, l.loma
        FROM zurnals z
        LEFT JOIN lietotaji l ON z.lietotaja_id = l.id
        WHERE 1=1";

$params = [];
if ($lietotaja_id > 0) {
    $sql .= " AND z.lietotaja_id = ?";
    $params[] = $lietotaja_id;
}
if (!empty($darbiba)) {
    $sql .= " AND z.darbiba LIKE ?";
    $params[] = '%' . $darbiba . '%';
}
if (!empty($datums_no)) {
    $sql .= " AND z.datums >= ?";
    $params[] = $datums_no . ' 00:00:00';
}
if (!empty($datums_lidz)) {
    $sql .= " AND z.datums <= ?";
    $params[] = $datums_lidz . ' 23:59:59';
}

$sql .= " ORDER BY z.datums DESC LIMIT 500";
$darbibas = $db->izpilditVaicajumu($sql, $params)->fetchAll();

// Iegūt visus lietotājus filtram
$visi_lietotaji = $db->izpilditVaicajumu("
    SELECT id, vards, uzvards, epasts, loma 
    FROM lietotaji 
    ORDER BY loma, vards, uzvards
")->fetchAll();

// Statistika
$kopējais_skaits = count($darbibas);
$šodienas_skaits = $db->izpilditVaicajumu("
    SELECT COUNT(*) as skaits FROM zurnals 
    WHERE DATE(datums) = CURDATE()
")->fetch()['skaits'];

$šonedēļas_skaits = $db->izpilditVaicajumu("
    SELECT COUNT(*) as skaits FROM zurnals 
    WHERE WEEK(datums) = WEEK(NOW()) AND YEAR(datums) = YEAR(NOW())
")->fetch()['skaits'];

// Jaunākās darbības (pēdējās 10)
$jaunakas_darbibas = array_slice($darbibas, 0, 10);
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Darbību žurnāls - Admin Panelis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        .table-container {
            max-height: 600px;
            overflow-y: auto;
        }
        .activity-badge {
            font-size: 0.75rem;
        }
        .role-badge {
            font-size: 0.7rem;
        }
    </style>
</head>
<body>
    <?php include '../includes/header.php'; ?>

    <div class="container mt-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1>Darbību žurnāls</h1>
            <a href="index.php" class="btn btn-secondary">Atpakaļ uz paneli</a>
        </div>

        <!-- Statistika -->
        <div class="row mt-4">
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-primary">
                    <div class="card-body">
                        <h5 class="card-title">Kopējais ierakstu skaits</h5>
                        <p class="card-text display-6"><?php echo $kopējais_skaits; ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-success">
                    <div class="card-body">
                        <h5 class="card-title">Šodienas darbības</h5>
                        <p class="card-text display-6"><?php echo $šodienas_skaits; ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card text-white bg-info">
                    <div class="card-body">
                        <h5 class="card-title">Šonedēļas darbības</h5>
                        <p class="card-text display-6"><?php echo $šonedēļas_skaits; ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filtri -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">Filtri</h5>
            </div>
            <div class="card-body">
                <form method="GET" action="" class="row g-3">
                    <div class="col-md-3">
                        <label for="lietotajs" class="form-label">Lietotājs</label>
                        <select class="form-select" id="lietotajs" name="lietotajs">
                            <option value="0">Visi lietotāji</option>
                            <?php foreach ($visi_lietotaji as $l): ?>
                                <option value="<?php echo $l['id']; ?>" <?php echo ($lietotaja_id == $l['id']) ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($l['vards'] . ' ' . $l['uzvards'] . ' (' . $l['loma'] . ')'); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="darbiba" class="form-label">Darbība</label>
                        <input type="text" class="form-control" id="darbiba" name="darbiba" 
                               placeholder="Meklēt darbību..." value="<?php echo htmlspecialchars($darbiba); ?>">
                    </div>
                    <div class="col-md-2">
                        <label for="datums_no" class="form-label">Datums no</label>
                        <input type="date" class="form-control" id="datums_no" name="datums_no" value="<?php echo $datums_no; ?>">
                    </div>
                    <div class="col-md-2">
                        <label for="datums_lidz" class="form-label">Datums līdz</label>
                        <input type="date" class="form-control" id="datums_lidz" name="datums_lidz" value="<?php echo $datums_lidz; ?>">
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">Filtrēt</button>
                    </div>
                </form>
                <?php if ($lietotaja_id > 0 || !empty($darbiba) || !empty($datums_no) || !empty($datums_lidz)): ?>
                    <div class="mt-3">
                        <a href="darbibas.php" class="btn btn-outline-secondary btn-sm">Notīrīt filtrus</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Jaunākās darbības -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Jaunākās darbības (pēdējās 10)</h5>
                        <span class="badge bg-secondary">Rāda <?php echo count($jaunakas_darbibas); ?> ierakstus</span>
                    </div>
                    <div class="card-body">
                        <?php if (empty($jaunakas_darbibas)): ?>
                            <div class="alert alert-info">
                                Nav darbību atbilstoši kritērijiem.
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>Datums un laiks</th>
                                            <th>Lietotājs</th>
                                            <th>Loma</th>
                                            <th>Darbība</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($jaunakas_darbibas as $d): ?>
                                            <tr>
                                                <td><?php echo date('d.m.Y H:i:s', strtotime($d['datums'])); ?></td>
                                                <td>
                                                    <?php if ($d['lietotaja_id']): ?>
                                                        <?php echo htmlspecialchars($d['vards'] . ' ' . $d['uzvards']); ?>
                                                        <br>
                                                        <small class="text-muted"><?php echo htmlspecialchars($d['epasts']); ?></small>
                                                    <?php else: ?>
                                                        <span class="text-muted">Sistēma</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php
                                                    $role_class = 'bg-secondary';
                                                    $role_text = $d['loma'] ?? 'nezināma';
                                                    if ($d['loma'] == 'administrators') {
                                                        $role_class = 'bg-danger';
                                                    } elseif ($d['loma'] == 'treneris') {
                                                        $role_class = 'bg-success';
                                                    } elseif ($d['loma'] == 'klients') {
                                                        $role_class = 'bg-primary';
                                                    }
                                                    ?>
                                                    <span class="badge <?php echo $role_class; ?>"><?php echo $role_text; ?></span>
                                                </td>
                                                <td><?php echo htmlspecialchars($d['darbiba']); ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Pilns žurnāls -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Pilns darbību žurnāls (pēdējie 500)</h5>
                    </div>
                    <div class="card-body table-container">
                        <?php if (empty($darbibas)): ?>
                            <div class="alert alert-info">
                                Nav darbību atbilstoši kritērijiem.
                            </div>
                        <?php else: ?>
                            <table class="table table-sm table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>Datums</th>
                                        <th>Lietotājs</th>
                                        <th>Darbība</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($darbibas as $d): ?>
                                        <tr>
                                            <td><small><?php echo date('d.m.Y H:i:s', strtotime($d['datums'])); ?></small></td>
                                            <td>
                                                <?php if ($d['lietotaja_id']): ?>
                                                    <small><?php echo htmlspecialchars($d['vards'] . ' ' . $d['uzvards']); ?></small>
                                                <?php else: ?>
                                                    <small class="text-muted">Sistēma</small>
                                                <?php endif; ?>
                                            </td>
                                            <td><small><?php echo htmlspecialchars($d['darbiba']); ?></small></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
