-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               10.4.32-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win64
-- HeidiSQL Version:             12.14.0.7165
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- Dumping database structure for sporta_zale
CREATE DATABASE IF NOT EXISTS `sporta_zale` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci */;
USE `sporta_zale`;

-- Dumping structure for table sporta_zale.inventars
CREATE TABLE IF NOT EXISTS `inventars` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unikāls inventāra ID',
  `nosaukums` varchar(100) NOT NULL COMMENT 'Inventāra vienības nosaukums',
  `apraksts` text DEFAULT NULL COMMENT 'Detalizēts apraksts',
  `daudzums` int(11) DEFAULT 1 COMMENT 'Pieejamais daudzums',
  `stavoklis` enum('labā stāvoklī','jāremontē','nolietots') DEFAULT 'labā stāvoklī' COMMENT 'Inventāra stāvoklis',
  `pirkuma_datums` date DEFAULT NULL COMMENT 'Pirkuma datums',
  `izveidots` datetime DEFAULT current_timestamp() COMMENT 'Ieraksta izveides laiks',
  `pievienoja_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_stavoklis` (`stavoklis`),
  KEY `idx_nosaukums` (`nosaukums`),
  KEY `idx_inventars_stavokli` (`stavoklis`,`pirkuma_datums`),
  KEY `idx_pievienoja_id` (`pievienoja_id`),
  CONSTRAINT `inventars_ibfk_3` FOREIGN KEY (`pievienoja_id`) REFERENCES `lietotaji` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Sporta inventāra uzskaites tabula';

-- Dumping data for table sporta_zale.inventars: ~7 rows (approximately)
INSERT INTO `inventars` (`id`, `nosaukums`, `apraksts`, `daudzums`, `stavoklis`, `pirkuma_datums`, `izveidots`, `pievienoja_id`) VALUES
	(6, 'Jogas paklājiņi', 'Standarta jogas paklājiņi', 20, 'labā stāvoklī', NULL, '2026-02-03 14:05:27', NULL),
	(8, 'Skrejceliņš', 'Elektriskais skrejceliņš', 5, 'labā stāvoklī', NULL, '2026-02-03 14:05:27', NULL),
	(9, 'Velotrenažieris', 'Stacionārais velosipēds', 8, 'labā stāvoklī', NULL, '2026-02-03 14:05:27', NULL),
	(10, 'Hanteles 10kg', '', 1, 'labā stāvoklī', '2026-02-03', '2026-02-03 17:18:33', NULL),
	(11, 'Paklajs', '', 1, 'labā stāvoklī', '2026-02-03', '2026-02-03 17:19:00', NULL),
	(20, 'Paklajs', 'asdasd', 1, 'labā stāvoklī', '2026-02-03', '2026-02-03 17:46:37', NULL),
	(21, 'Peldesana', '', 1, 'nolietots', '2026-02-03', '2026-02-03 17:47:46', 15);

-- Dumping structure for table sporta_zale.lietotaji
CREATE TABLE IF NOT EXISTS `lietotaji` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unikāls lietotāja identifikators',
  `vards` varchar(50) NOT NULL COMMENT 'Lietotāja vārds',
  `uzvards` varchar(50) NOT NULL COMMENT 'Lietotāja uzvārds',
  `epasts` varchar(100) NOT NULL COMMENT 'Unikāla e-pasta adrese',
  `parole` varchar(255) NOT NULL COMMENT 'Hash-ota parole',
  `loma` enum('administrators','treneris','klients') DEFAULT 'klients' COMMENT 'Lietotāja loma sistēmā',
  `telefons` varchar(20) DEFAULT NULL COMMENT 'Kontakttelefons',
  `dzimsanas_datums` date DEFAULT NULL COMMENT 'Dzimšanas datums',
  `profila_bilde` varchar(255) DEFAULT NULL COMMENT 'Profila attēla ceļš',
  `aktivizets` tinyint(1) DEFAULT 1 COMMENT 'Vai konts ir aktīvs (TRUE/FALSE)',
  `pierakstisanas_skaititajs` int(11) DEFAULT 0 COMMENT 'Veikto pierakstīšanās skaits',
  `pedeja_pierakstisanas` datetime DEFAULT NULL COMMENT 'Pēdējās pierakstīšanās laiks',
  `izveidots` datetime DEFAULT current_timestamp() COMMENT 'Konta izveides laiks',
  `atjauninats` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Pēdējā atjaunošanas laiks',
  PRIMARY KEY (`id`),
  UNIQUE KEY `epasts` (`epasts`),
  KEY `idx_lietotaji_epasts` (`epasts`),
  KEY `idx_lietotaji_loma` (`loma`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Sistēmas lietotāju tabula (administratori, treneri, klienti)';

-- Dumping data for table sporta_zale.lietotaji: ~8 rows (approximately)
INSERT INTO `lietotaji` (`id`, `vards`, `uzvards`, `epasts`, `parole`, `loma`, `telefons`, `dzimsanas_datums`, `profila_bilde`, `aktivizets`, `pierakstisanas_skaititajs`, `pedeja_pierakstisanas`, `izveidots`, `atjauninats`) VALUES
	(9, 'Admin', 'Administrators', 'admin@sportazale.lv', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'administrators', NULL, NULL, NULL, 1, 0, NULL, '2026-02-03 14:05:27', '2026-02-03 14:05:27'),
	(10, 'Jānis', 'Treneris', 'treneris@sportazale.lv', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'treneris', NULL, NULL, NULL, 1, 0, NULL, '2026-02-03 14:05:27', '2026-02-03 14:05:27'),
	(11, 'Anna', 'Kliente', 'klients@sportazale.lv', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'klients', NULL, NULL, NULL, 1, 0, NULL, '2026-02-03 14:05:27', '2026-02-03 14:05:27'),
	(12, 'Danills', 'DL', 'daniils@gmail.com', '$2y$10$j7RKNnIcqCzMVOCCz6cwBOmH4Cl/JJvwp2/mkM8WRUajpL6MjVzIS', 'klients', '+37127039777', '2006-04-07', 'assets/uploads/profile_pictures/user_12_1770129336.jpg', 1, 16, '2026-02-03 18:58:56', '2026-02-03 16:07:39', '2026-02-03 18:58:56'),
	(13, 'Nikita', 'Nikitenko', 'nikita@gmail.com', '$2y$10$SvTCjnI1YlCux6KC93SCROfAx19reQ.hlUjNUAERMVaWKosgGTvNG', 'administrators', '+37127039777', '2006-04-07', NULL, 1, 12, '2026-02-03 18:40:22', '2026-02-03 16:08:18', '2026-02-03 18:40:22'),
	(14, 'Nikita', 'Nikitenko', 'treneris@gmail.com', '$2y$10$GQy9YGmIOdBM0KnMcPVTfeefI243nsJpbrLAUh8pRh.TWQZRcwzHC', 'treneris', NULL, NULL, NULL, 1, 15, '2026-02-03 18:32:11', '2026-02-03 16:08:56', '2026-02-03 18:32:11'),
	(15, 'Treneris', '2', 'treneris2@gmail.com', '$2y$10$ynPZJZ3d9aAy4YAH2yXF8.251cu5F2/raBXM.EcC8Tye6SteF2Noq', 'treneris', NULL, NULL, NULL, 1, 1, '2026-02-03 17:47:41', '2026-02-03 17:47:25', '2026-02-03 17:47:41'),
	(16, 'Nikita', 'DL', '123@gmail.com', '$2y$10$wA0jwYgooUmEo7XjtEuGd.LY60dvzCw5OxF8vaigy7I4vKzmlK.Uq', 'administrators', NULL, NULL, NULL, 1, 0, NULL, '2026-02-03 18:15:00', '2026-02-03 18:15:00');

-- Dumping structure for table sporta_zale.nodarbibas
CREATE TABLE IF NOT EXISTS `nodarbibas` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unikāls nodarbības ID',
  `nosaukums` varchar(100) NOT NULL COMMENT 'Nodarbības nosaukums',
  `apraksts` text DEFAULT NULL COMMENT 'Detalizēts nodarbības apraksts',
  `nepieciesamais_inventars` text DEFAULT NULL COMMENT 'Nepieciešamais inventārs (katru jaunā rindā)',
  `treneris_id` int(11) NOT NULL COMMENT 'Atsauce uz treneri (lietotaji.id)',
  `sakuma_laiks` datetime NOT NULL COMMENT 'Nodarbības sākuma laiks',
  `beigu_laiks` datetime NOT NULL COMMENT 'Nodarbības beigu laiks',
  `maksimalais_dalibnieku_skaits` int(11) DEFAULT 20 COMMENT 'Maksimālais dalībnieku skaits',
  `stavoklis` enum('aktīva','atcelta','pabeigta') DEFAULT 'aktīva' COMMENT 'Nodarbības pašreizējais statuss',
  `izveidots` datetime DEFAULT current_timestamp() COMMENT 'Ieraksta izveides laiks',
  PRIMARY KEY (`id`),
  KEY `idx_sakuma_laiks` (`sakuma_laiks`),
  KEY `idx_stavoklis` (`stavoklis`),
  KEY `idx_nodarbibas_treneris` (`treneris_id`),
  KEY `idx_nodarbibas_laiks` (`sakuma_laiks`,`beigu_laiks`),
  CONSTRAINT `nodarbibas_ibfk_1` FOREIGN KEY (`treneris_id`) REFERENCES `lietotaji` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Treniņu nodarbību grafika tabula';

-- Dumping data for table sporta_zale.nodarbibas: ~8 rows (approximately)
INSERT INTO `nodarbibas` (`id`, `nosaukums`, `apraksts`, `nepieciesamais_inventars`, `treneris_id`, `sakuma_laiks`, `beigu_laiks`, `maksimalais_dalibnieku_skaits`, `stavoklis`, `izveidots`) VALUES
	(6, 'Joga iesācējiem', 'Mierīga jogas nodarbība iesācējiem', NULL, 2, '2026-02-04 14:05:27', '2026-02-04 15:05:27', 15, 'aktīva', '2026-02-03 14:05:27'),
	(7, 'Kardio treniņš', 'Intensīvs kardio treniņš', NULL, 10, '2026-02-03 14:05:00', '2026-02-05 14:50:00', 20, 'aktīva', '2026-02-03 14:05:27'),
	(9, 'Peldesana', '', NULL, 9, '2026-02-03 16:05:00', '2026-02-03 16:07:00', 10, 'pabeigta', '2026-02-03 16:06:30'),
	(11, 'Peldesana', '', NULL, 14, '2026-02-03 17:19:00', '2026-02-03 17:25:00', 10, 'pabeigta', '2026-02-03 17:19:48'),
	(12, 'Hanteles 10kg', '', NULL, 14, '2026-02-03 17:23:00', '2026-02-03 17:30:00', 10, 'pabeigta', '2026-02-03 17:24:47'),
	(13, 'Test', '', NULL, 14, '2026-02-03 23:00:00', '2026-02-03 23:15:00', 10, 'pabeigta', '2026-02-03 17:30:30'),
	(14, 'Paklajs', '', NULL, 15, '2025-02-01 02:02:00', '2000-02-02 02:02:00', 10, 'pabeigta', '2026-02-03 18:07:43'),
	(15, 'Peldesana', '', NULL, 10, '2000-01-01 22:22:00', '2000-02-01 22:22:00', 10, 'pabeigta', '2026-02-03 18:13:23'),
	(17, 'Peldesana', 'apraksts', NULL, 14, '2026-02-03 20:00:00', '2026-02-03 21:00:00', 10, 'aktīva', '2026-02-03 18:27:24'),
	(18, 'фывафвыа', 'фвыафвав', '', 10, '2026-02-04 20:00:00', '2026-03-04 21:00:00', 10, 'aktīva', '2026-02-03 18:44:36');

-- Dumping structure for table sporta_zale.pieraksti
CREATE TABLE IF NOT EXISTS `pieraksti` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unikāls pieraksta ID',
  `lietotaja_id` int(11) NOT NULL COMMENT 'Atsauce uz klientu (lietotaji.id)',
  `nodarbibas_id` int(11) NOT NULL COMMENT 'Atsauce uz nodarbību (nodarbibas.id)',
  `pieraksta_datums` datetime DEFAULT current_timestamp() COMMENT 'Pierakstīšanās datums un laiks',
  `stavoklis` enum('apstiprināts','atcelts','pabeigts') DEFAULT 'apstiprināts' COMMENT 'Pieraksta statuss',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_pieraksts` (`lietotaja_id`,`nodarbibas_id`) COMMENT 'Novērš dubultpierakstus',
  KEY `idx_stavoklis` (`stavoklis`),
  KEY `idx_lietotaja` (`lietotaja_id`),
  KEY `nodarbibas_id` (`nodarbibas_id`),
  KEY `idx_pieraksti_datumu` (`pieraksta_datums`),
  CONSTRAINT `pieraksti_ibfk_1` FOREIGN KEY (`lietotaja_id`) REFERENCES `lietotaji` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `pieraksti_ibfk_2` FOREIGN KEY (`nodarbibas_id`) REFERENCES `nodarbibas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Klientu pierakstu uz nodarbībām tabula';

-- Dumping data for table sporta_zale.pieraksti: ~2 rows (approximately)
INSERT INTO `pieraksti` (`id`, `lietotaja_id`, `nodarbibas_id`, `pieraksta_datums`, `stavoklis`) VALUES
	(11, 12, 13, '2026-02-03 17:30:43', 'apstiprināts'),
	(14, 12, 17, '2026-02-03 18:59:05', 'apstiprināts');

-- Dumping structure for table sporta_zale.zinojumi
CREATE TABLE IF NOT EXISTS `zinojumi` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unikāls ziņojuma ID',
  `no_lietotaja_id` int(11) NOT NULL COMMENT 'Sūtītāja lietotāja ID',
  `kam_lietotaja_id` int(11) NOT NULL COMMENT 'Saņēmēja lietotāja ID',
  `teksts` text NOT NULL COMMENT 'Ziņojuma teksts',
  `nosutits` datetime DEFAULT current_timestamp() COMMENT 'Nosūtīšanas laiks',
  `izlasits` tinyint(1) DEFAULT 0 COMMENT 'Vai ziņojums ir izlasīts',
  PRIMARY KEY (`id`),
  KEY `idx_no_lietotaja` (`no_lietotaja_id`),
  KEY `idx_kam_lietotaja` (`kam_lietotaja_id`),
  KEY `idx_nosutits` (`nosutits`),
  KEY `idx_izlasits` (`izlasits`),
  CONSTRAINT `zinojumi_ibfk_1` FOREIGN KEY (`no_lietotaja_id`) REFERENCES `lietotaji` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `zinojumi_ibfk_2` FOREIGN KEY (`kam_lietotaja_id`) REFERENCES `lietotaji` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Ziņojumu tabula čatam starp treneriem un klientiem';

-- Dumping data for table sporta_zale.zinojumi: ~5 rows (approximately)
INSERT INTO `zinojumi` (`id`, `no_lietotaja_id`, `kam_lietotaja_id`, `teksts`, `nosutits`, `izlasits`) VALUES
	(1, 14, 12, 'Sveiki', '2026-02-03 16:10:10', 1),
	(2, 12, 14, 'Cau', '2026-02-03 16:10:34', 1),
	(3, 12, 14, 'Hey', '2026-02-03 16:24:25', 1),
	(4, 12, 14, 'sup', '2026-02-03 17:01:47', 1),
	(5, 12, 14, 'рун', '2026-02-03 17:38:34', 1);

-- Dumping structure for table sporta_zale.zurnals
CREATE TABLE IF NOT EXISTS `zurnals` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unikāls žurnāla ieraksta ID',
  `lietotaja_id` int(11) DEFAULT NULL COMMENT 'Atsauce uz lietotāju (lietotaji.id)',
  `darbiba` varchar(100) NOT NULL COMMENT 'Veiktā darbība',
  `datums` datetime DEFAULT current_timestamp() COMMENT 'Darbības datums un laiks',
  `ip_adrese` varchar(45) DEFAULT NULL COMMENT 'Lietotāja IP adrese',
  PRIMARY KEY (`id`),
  KEY `idx_datums` (`datums`),
  KEY `idx_lietotaja_darbiba` (`lietotaja_id`,`darbiba`),
  KEY `idx_zurnals_lietotajs` (`lietotaja_id`,`datums`),
  CONSTRAINT `zurnals_ibfk_1` FOREIGN KEY (`lietotaja_id`) REFERENCES `lietotaji` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Sistēmas darbību žurnāla tabula';

-- Dumping data for table sporta_zale.zurnals: ~45 rows (approximately)
INSERT INTO `zurnals` (`id`, `lietotaja_id`, `darbiba`, `datums`, `ip_adrese`) VALUES
	(1, 12, 'Nosūtīja ziņojumu lietotājam: Nikita Nikitenko', '2026-02-03 16:24:25', '::1'),
	(2, 12, 'Atjaunoja profilu', '2026-02-03 16:35:36', '::1'),
	(3, 12, 'Atjaunoja profilu', '2026-02-03 16:36:25', '::1'),
	(4, 13, 'Atjaunoja profilu', '2026-02-03 16:37:00', '::1'),
	(5, 13, 'Atjaunoja profilu', '2026-02-03 16:59:36', '::1'),
	(6, 12, 'Nosūtīja ziņojumu: Nikita Nikitenko', '2026-02-03 17:01:47', '::1'),
	(7, 14, 'Pievienoja inventāru: Hanteles 10kg', '2026-02-03 17:18:33', '::1'),
	(8, 14, 'Izdzēsa inventāru: ', '2026-02-03 17:18:48', '::1'),
	(9, 14, 'Pievienoja inventāru: Paklajs', '2026-02-03 17:19:00', '::1'),
	(10, 14, 'Izveidoja nodarbību: Hanteles 10kg', '2026-02-03 17:24:47', '::1'),
	(11, 14, 'Izveidoja nodarbību: Test', '2026-02-03 17:30:30', '::1'),
	(12, 12, 'Pierakstījās uz nodarbību: Test', '2026-02-03 17:30:43', '::1'),
	(13, 12, 'Nosūtīja ziņojumu: Nikita Nikitenko', '2026-02-03 17:38:34', '::1'),
	(14, 12, 'Atjaunoja profilu', '2026-02-03 17:39:06', '::1'),
	(15, 12, 'Atjaunoja profilu', '2026-02-03 17:39:37', '::1'),
	(16, 14, 'Pievienoja inventāru: Test', '2026-02-03 17:41:26', '::1'),
	(17, 14, 'Pievienoja inventāru: Test', '2026-02-03 17:43:59', '::1'),
	(18, 14, 'Pievienoja inventāru: Test', '2026-02-03 17:45:47', '::1'),
	(19, 14, 'Pievienoja inventāru: Test', '2026-02-03 17:45:49', '::1'),
	(20, 14, 'Pievienoja inventāru: Test', '2026-02-03 17:45:49', '::1'),
	(21, 14, 'Pievienoja inventāru: Test', '2026-02-03 17:45:52', '::1'),
	(22, 14, 'Pievienoja inventāru: Test', '2026-02-03 17:45:53', '::1'),
	(23, 14, 'Pievienoja inventāru: Test', '2026-02-03 17:45:53', '::1'),
	(24, 14, 'Izdzēsa inventāru: ', '2026-02-03 17:45:55', '::1'),
	(25, 14, 'Izdzēsa inventāru: ', '2026-02-03 17:45:58', '::1'),
	(26, 14, 'Izdzēsa inventāru: ', '2026-02-03 17:46:00', '::1'),
	(27, 14, 'Izdzēsa inventāru: ', '2026-02-03 17:46:05', '::1'),
	(28, 14, 'Izdzēsa inventāru: ', '2026-02-03 17:46:07', '::1'),
	(29, 14, 'Izdzēsa inventāru: ', '2026-02-03 17:46:07', '::1'),
	(30, 14, 'Izdzēsa inventāru: ', '2026-02-03 17:46:08', '::1'),
	(31, 14, 'Izdzēsa inventāru: ', '2026-02-03 17:46:08', '::1'),
	(32, 15, 'Pievienoja inventāru: Peldesana', '2026-02-03 17:47:46', '::1'),
	(33, 14, 'Pievienoja inventāru: Peldesana', '2026-02-03 17:50:40', '::1'),
	(34, 14, 'Rediģēja inventāru: Peldesana', '2026-02-03 17:50:43', '::1'),
	(35, 14, 'Izdzēsa inventāru: ', '2026-02-03 17:50:46', '::1'),
	(36, 14, 'Izveidoja nodarbību: Test', '2026-02-03 18:26:41', '::1'),
	(37, 14, 'Izveidoja nodarbību: Peldesana', '2026-02-03 18:27:24', '::1'),
	(38, 12, 'Pierakstījās uz nodarbību: Peldesana', '2026-02-03 18:31:46', '::1'),
	(39, 12, 'Izrakstījās no nodarbības: Peldesana', '2026-02-03 18:31:48', '::1'),
	(40, 12, 'Pierakstījās uz nodarbību: Peldesana', '2026-02-03 18:31:53', '::1'),
	(41, 12, 'Izrakstījās no nodarbības: Peldesana', '2026-02-03 18:31:55', '::1'),
	(42, 14, 'Rediģēja nodarbību: Peldesana', '2026-02-03 18:32:22', '::1'),
	(43, 14, 'Rediģēja nodarbību: Peldesana', '2026-02-03 18:40:07', '::1'),
	(44, 14, 'Rediģēja nodarbību: Peldesana', '2026-02-03 18:40:11', '::1'),
	(45, 12, 'Pierakstījās uz nodarbību: Peldesana', '2026-02-03 18:59:05', '::1');

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
