<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/database.php';
require_once '../includes/auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasRole('treneris')) {
    header("Location: ../index.php");
    exit();
}

$db = Database::getInstance();
$current_user = $auth->getCurrentUser();

// Ielādēt nodarbības datus (tikai savas nodarbības)
$nodarbiba = null;
if (isset($_GET['id'])) {
    $stmt = $db->izpilditVaicajumu("SELECT * FROM nodarbibas WHERE id = ? AND treneris_id = ?", [$_GET['id'], $current_user['id']]);
    $nodarbiba = $stmt->fetch();
    
    if (!$nodarbiba) {
        header("Location: mans_grafiks.php");
        exit();
    }
} else {
    header("Location: mans_grafiks.php");
    exit();
}

// Apstrādāt formas iesniegšanu
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nosaukums = trim($_POST['nosaukums']);
    $apraksts = trim($_POST['apraksts']);
    $sakuma_laiks = $_POST['sakuma_laiks'];
    $beigu_laiks = $_POST['beigu_laiks'];
    $maksimalais_dalibnieku_skaits = intval($_POST['maksimalais_dalibnieku_skaits']);
    $stavoklis = $_POST['stavoklis'];
    
    try {
        $db->izpilditVaicajumu(
            "UPDATE nodarbibas SET nosaukums = ?, apraksts = ?, sakuma_laiks = ?, beigu_laiks = ?, maksimalais_dalibnieku_skaits = ?, stavoklis = ? WHERE id = ? AND treneris_id = ?",
            [$nosaukums, $apraksts, $sakuma_laiks, $beigu_laiks, $maksimalais_dalibnieku_skaits, $stavoklis, $_GET['id'], $current_user['id']]
        );
        
        header("Location: mans_grafiks.php?success=2");
        exit();
        
    } catch (Exception $e) {
        $error = "Kļūda labojot nodarbību: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rediģēt nodarbību - Treneris</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">💪 Sporta Zāle - Treneris</a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="index.php">Panelis</a>
                <a class="nav-link" href="mans_grafiks.php">Mans grafiks</a>
                <a class="nav-link" href="mani_klienti.php">Mani klienti</a>
                <a class="nav-link" href="../includes/izlogoties.php">Izlogoties</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h5 class="card-title mb-0">✏️ Rediģēt nodarbību</h5>
                    </div>
                    <div class="card-body">
                        <?php if (isset($error)): ?>
                            <div class="alert alert-danger"><?php echo $error; ?></div>
                        <?php endif; ?>
                        
                        <form method="POST">
                            <div class="mb-3">
                                <label for="nosaukums" class="form-label">Nosaukums</label>
                                <input type="text" class="form-control" id="nosaukums" name="nosaukums" 
                                       value="<?php echo htmlspecialchars($nodarbiba['nosaukums']); ?>" required>
                            </div>
                            
                            <div class="mb-3">
                                <label for="apraksts" class="form-label">Apraksts</label>
                                <textarea class="form-control" id="apraksts" name="apraksts" rows="3"><?php echo htmlspecialchars($nodarbiba['apraksts']); ?></textarea>
                            </div>
                            
                            <div class="mb-3">
                                <label for="sakuma_laiks" class="form-label">Sākuma laiks</label>
                                <input type="datetime-local" class="form-control" id="sakuma_laiks" name="sakuma_laiks" 
                                       value="<?php echo date('Y-m-d\TH:i', strtotime($nodarbiba['sakuma_laiks'])); ?>" required>
                            </div>
                            
                            <div class="mb-3">
                                <label for="beigu_laiks" class="form-label">Beigu laiks</label>
                                <input type="datetime-local" class="form-control" id="beigu_laiks" name="beigu_laiks" 
                                       value="<?php echo date('Y-m-d\TH:i', strtotime($nodarbiba['beigu_laiks'])); ?>" required>
                            </div>
                            
                            <div class="mb-3">
                                <label for="maksimalais_dalibnieku_skaits" class="form-label">Maksimālais dalībnieku skaits</label>
                                <input type="number" class="form-control" id="maksimalais_dalibnieku_skaits" name="maksimalais_dalibnieku_skaits" 
                                       value="<?php echo $nodarbiba['maksimalais_dalibnieku_skaits']; ?>" min="1" required>
                            </div>
                            
                            <div class="mb-3">
                                <label for="stavoklis" class="form-label">Statuss</label>
                                <select class="form-select" id="stavoklis" name="stavoklis" required>
                                    <option value="aktīva" <?php echo $nodarbiba['stavoklis'] == 'aktīva' ? 'selected' : ''; ?>>Aktīva</option>
                                    <option value="atcelta" <?php echo $nodarbiba['stavoklis'] == 'atcelta' ? 'selected' : ''; ?>>Atcelta</option>
                                </select>
                            </div>
                            
                            <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                <a href="mans_grafiks.php" class="btn btn-secondary me-md-2">Atpakaļ</a>
                                <button type="submit" class="btn btn-primary">Saglabāt izmaiņas</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>