<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/database.php';
require_once '../includes/auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasRole('treneris')) {
    header("Location: ../index.php");
    exit();
}

$db = Database::getInstance();
$current_user = $auth->getCurrentUser();

// Dzēšanas funkcija (tikai savām nodarbībām)
if (isset($_GET['dzest'])) {
    $id = intval($_GET['dzest']);
    
    // Pārbaudīt vai nodarbība pieder trenerim
    $check = $db->izpilditVaicajumu("SELECT * FROM nodarbibas WHERE id = ? AND treneris_id = ?", [$id, $current_user['id']]);
    if ($check->fetch()) {
        $db->izpilditVaicajumu("DELETE FROM nodarbibas WHERE id = ?", [$id]);
        header("Location: mans_grafiks.php?success=3");
        exit();
    } else {
        header("Location: mans_grafiks.php?error=1");
        exit();
    }
}

// Atcelšanas funkcija (tikai savām nodarbībām)
if (isset($_GET['atcelt'])) {
    $id = intval($_GET['atcelt']);
    
    $check = $db->izpilditVaicajumu("SELECT * FROM nodarbibas WHERE id = ? AND treneris_id = ?", [$id, $current_user['id']]);
    if ($check->fetch()) {
        $db->izpilditVaicajumu("UPDATE nodarbibas SET stavoklis = 'atcelta' WHERE id = ?", [$id]);
        header("Location: mans_grafiks.php?success=4");
        exit();
    } else {
        header("Location: mans_grafiks.php?error=2");
        exit();
    }
}

// Aktivizēšanas funkcija (tikai savām nodarbībām)
if (isset($_GET['aktivizet'])) {
    $id = intval($_GET['aktivizet']);
    
    $check = $db->izpilditVaicajumu("SELECT * FROM nodarbibas WHERE id = ? AND treneris_id = ?", [$id, $current_user['id']]);
    if ($check->fetch()) {
        $db->izpilditVaicajumu("UPDATE nodarbibas SET stavoklis = 'aktīva' WHERE id = ?", [$id]);
        header("Location: mans_grafiks.php?success=5");
        exit();
    } else {
        header("Location: mans_grafiks.php?error=3");
        exit();
    }
}

// Veiksmes ziņojumi
$success_message = '';
if (isset($_GET['success'])) {
    switch ($_GET['success']) {
        case '1': $success_message = 'Nodarbība veiksmīgi pievienota!'; break;
        case '2': $success_message = 'Nodarbība veiksmīgi rediģēta!'; break;
        case '3': $success_message = 'Nodarbība veiksmīgi dzēsta!'; break;
        case '4': $success_message = 'Nodarbība atcelta!'; break;
        case '5': $success_message = 'Nodarbība aktivizēta!'; break;
    }
}

// Kļūdu ziņojumi
$error_message = '';
if (isset($_GET['error'])) {
    switch ($_GET['error']) {
        case '1': $error_message = 'Kļūda dzēšot nodarbību!'; break;
        case '2': $error_message = 'Kļūda atceļot nodarbību!'; break;
        case '3': $error_message = 'Kļūda aktivizējot nodarbību!'; break;
    }
}

// Iegūstam tikai trenera nodarbības
$nodarbibas = $db->izpilditVaicajumu("
    SELECT n.*, l.vards AS trenera_vards, l.uzvards AS trenera_uzvards,
           (SELECT COUNT(*) FROM pieraksti p WHERE p.nodarbibas_id = n.id) AS pierakstu_skaits
    FROM nodarbibas n
    LEFT JOIN lietotaji l ON n.treneris_id = l.id
    WHERE n.treneris_id = ?
    ORDER BY n.sakuma_laiks DESC
", [$current_user['id']])->fetchAll();
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mans grafiks - Treneris</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-success">
        <div class="container">
            <a class="navbar-brand" href="#">💪 Sporta Zāle - Treneris</a>
            <div class="navbar-nav ms-auto">
                <span class="navbar-text me-3">
                    Sveiks, <?php echo htmlspecialchars($current_user['vards']); ?>!
                </span>
                <a class="nav-link" href="index.php">Panelis</a>
                <a class="nav-link" href="mans_grafiks.php">Mans grafiks</a>
                <a class="nav-link" href="mani_klienti.php">Mani klienti</a>
                <a class="nav-link" href="../dashboard.php">Dashboard</a>
                <a class="nav-link" href="../includes/izlogoties.php">Izlogoties</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1>Mans nodarbību grafiks</h1>
            <a href="pievienot_nodarbibu.php" class="btn btn-success">Pievienot jaunu nodarbību</a>
        </div>

        <!-- Veiksmes ziņojumi -->
        <?php if (!empty($success_message)): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo $success_message; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <!-- Kļūdu ziņojumi -->
        <?php if (!empty($error_message)): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php echo $error_message; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="row">
            <?php if (empty($nodarbibas)): ?>
                <div class="col-12">
                    <div class="alert alert-info">
                        Jums vēl nav pievienota neviena nodarbība.
                    </div>
                </div>
            <?php else: ?>
                <?php foreach ($nodarbibas as $nodarbiba): ?>
                    <div class="col-md-6 col-lg-4 mb-4">
                        <div class="card h-100">
                            <div class="card-header">
                                <h5 class="card-title mb-0"><?php echo htmlspecialchars($nodarbiba['nosaukums']); ?></h5>
                            </div>
                            <div class="card-body">
                                <p class="card-text"><?php echo htmlspecialchars($nodarbiba['apraksts']); ?></p>
                                <p class="card-text">
                                    <strong>Laiks:</strong> <?php echo date('d.m.Y H:i', strtotime($nodarbiba['sakuma_laiks'])); ?><br>
                                    <strong>Dalībnieki:</strong> <?php echo $nodarbiba['pierakstu_skaits']; ?>/<?php echo $nodarbiba['maksimalais_dalibnieku_skaits']; ?>
                                </p>
                                <p class="card-text">
                                    <span class="badge 
                                        <?php echo $nodarbiba['stavoklis'] == 'aktīva' ? 'bg-success' : 
                                               ($nodarbiba['stavoklis'] == 'atcelta' ? 'bg-danger' : 'bg-secondary'); ?>">
                                        <?php echo $nodarbiba['stavoklis']; ?>
                                    </span>
                                </p>
                            </div>
                            <div class="card-footer">
                                <div class="btn-group w-100">
                                    <a href="rediget_nodarbibu.php?id=<?php echo $nodarbiba['id']; ?>" class="btn btn-outline-primary btn-sm">Rediģēt</a>
                                    
                                    <?php if ($nodarbiba['stavoklis'] == 'aktīva'): ?>
                                        <a href="mans_grafiks.php?atcelt=<?php echo $nodarbiba['id']; ?>" 
                                           class="btn btn-outline-warning btn-sm"
                                           onclick="return confirm('Vai tiešām vēlaties atcelt nodarbību \"<?php echo addslashes($nodarbiba['nosaukums']); ?>\"?')">
                                            Atcelt
                                        </a>
                                    <?php else: ?>
                                        <a href="mans_grafiks.php?aktivizet=<?php echo $nodarbiba['id']; ?>" 
                                           class="btn btn-outline-success btn-sm"
                                           onclick="return confirm('Vai tiešām vēlaties aktivizēt nodarbību \"<?php echo addslashes($nodarbiba['nosaukums']); ?>\"?')">
                                            Aktivizēt
                                        </a>
                                    <?php endif; ?>
                                    
                                    <a href="mans_grafiks.php?dzest=<?php echo $nodarbiba['id']; ?>" 
                                       class="btn btn-outline-danger btn-sm"
                                       onclick="return confirm('Vai tiešām vēlaties dzēst nodarbību \"<?php echo addslashes($nodarbiba['nosaukums']); ?>\"? Šo darbību nevarēs atsaukt!')">
                                        Dzēst
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>