<?php
session_start();
require_once '../includes/config.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasRole('treneris')) {
    header("Location: ../index.php");
    exit();
}

$lietotajs = $auth->getCurrentUser();
$db = Database::getInstance();

$klienti = $db->izpilditVaicajumu("
    SELECT DISTINCT l.id, l.vards, l.uzvards, l.epasts, l.telefons,
           (SELECT COUNT(*) FROM pieraksti p 
            JOIN nodarbibas n ON p.nodarbibas_id = n.id 
            WHERE p.lietotaja_id = l.id AND n.treneris_id = ?) as nodarbibu_skaits
    FROM lietotaji l
    JOIN pieraksti p ON l.id = p.lietotaja_id
    JOIN nodarbibas n ON p.nodarbibas_id = n.id
    WHERE n.treneris_id = ? AND l.loma = 'klients'
    ORDER BY nodarbibu_skaits DESC
", [$lietotajs['id'], $lietotajs['id']])->fetchAll();
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mani Klienti - Trenera Panelis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-success">
        <div class="container">
            <a class="navbar-brand" href="#">💪 Sporta Zāle - Treneris</a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="index.php">Panelis</a>
                <a class="nav-link" href="../dashboard.php">Dashboard</a>
                <a class="nav-link" href="../includes/izlogoties.php">Izlogoties</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <h1>Mani Klienti</h1>
        
        <div class="row mt-4">
            <div class="col-12">
                <?php if (empty($klienti)): ?>
                    <div class="alert alert-info">
                        Jums vēl nav klientu.
                    </div>
                <?php else: ?>
                    <div class="row">
                        <?php foreach ($klienti as $klients): ?>
                            <div class="col-md-6 col-lg-4 mb-4">
                                <div class="card h-100">
                                    <div class="card-body text-center">
                                        <div class="mb-3">
                                            <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center" 
                                                 style="width: 80px; height: 80px; font-size: 2rem;">
                                                <?php echo strtoupper(substr($klients['vards'], 0, 1) . substr($klients['uzvards'], 0, 1)); ?>
                                            </div>
                                        </div>
                                        <h5 class="card-title"><?php echo htmlspecialchars($klients['vards'] . ' ' . $klients['uzvards']); ?></h5>
                                        <p class="card-text">
                                            <strong>E-pasts:</strong> <?php echo htmlspecialchars($klients['epasts']); ?><br>
                                            <strong>Telefons:</strong> <?php echo $klients['telefons'] ?: 'Nav norādīts'; ?><br>
                                            <strong>Nodarbības:</strong> 
                                            <span class="badge bg-primary"><?php echo $klients['nodarbibu_skaits']; ?></span>
                                        </p>
                                    </div>
                                    <div class="card-footer">
                                        <button class="btn btn-outline-primary btn-sm w-100" 
                                                onclick="sutitZinu('<?php echo htmlspecialchars($klients['epasts']); ?>')">
                                            Sūtīt ziņu
                                        </button>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script>
    function sutitZinu(epasts) {
        const zina = prompt('Ievadiet ziņu klientam ' + epasts + ':');
        if (zina) {
            alert('Ziņa nosūtīta klientam: ' + zina);
            // Šeit varētu būt AJAX pieprasījums e-pasta sūtīšanai
        }
    }
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>