<?php
session_start();
require_once '../includes/config.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || !$auth->hasRole('treneris')) {
    header("Location: ../index.php");
    exit();
}

$lietotajs = $auth->getCurrentUser();

$db = Database::getInstance();
$sql = "SELECT * FROM nodarbibas WHERE treneris_id = ? AND sakuma_laiks > NOW() ORDER BY sakuma_laiks LIMIT 5";
$nodarbibas = $db->izpilditVaicajumu($sql, [$lietotajs['id']])->fetchAll();
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Trenera Panelis - Sporta Zāle</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-success">
        <div class="container">
            <a class="navbar-brand" href="#">💪 Sporta Zāle - Treneris</a>
            <div class="navbar-nav ms-auto">
                <span class="navbar-text me-3">
                    Sveiks, <?php echo htmlspecialchars($lietotajs['vards']); ?>!
                </span>
                <a class="nav-link" href="../dashboard.php">Dashboard</a>
                <a class="nav-link" href="../includes/izlogoties.php">Izlogoties</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <h1>Trenera Panelis</h1>
        
        <!-- Gaidāmās nodarbības -->
        <div class="row mt-4">
            <div class="col-12">
                <h3>Jūsu gaidāmās nodarbības</h3>
                <?php if (empty($nodarbibas)): ?>
                    <div class="alert alert-info">
                        Jums nav gaidāmo nodarbību.
                    </div>
                <?php else: ?>
                    <div class="row">
                        <?php foreach ($nodarbibas as $nodarbiba): ?>
                            <div class="col-md-6 mb-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title"><?php echo htmlspecialchars($nodarbiba['nosaukums']); ?></h5>
                                        <p class="card-text">
                                            <strong>Laiks:</strong> <?php echo date('d.m.Y H:i', strtotime($nodarbiba['sakuma_laiks'])); ?><br>
                                            <strong>Apraksts:</strong> <?php echo htmlspecialchars($nodarbiba['apraksts']); ?>
                                        </p>
                                        <a href="mans_grafiks.php" class="btn btn-primary btn-sm">Skatīt vairāk</a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Ātrās darbības -->
        <div class="row mt-4">
            <div class="col-12">
                <h3>Ātrās darbības</h3>
                <div class="row mt-3">
                    <div class="col-md-3 mb-2">
                        <a href="mans_grafiks.php" class="btn btn-outline-primary w-100">Mans grafiks</a>
                    </div>
                    <div class="col-md-3 mb-2">
                        <a href="mani_klienti.php" class="btn btn-outline-success w-100">Mani klienti</a>
                    </div>
                    <div class="col-md-3 mb-2">
                        <a href="../dashboard.php" class="btn btn-outline-secondary w-100">Dashboard</a>
                    </div>
                    <div class="col-md-3 mb-2">
                        <a href="../includes/izlogoties.php" class="btn btn-outline-danger w-100">Izlogoties</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>